#
# TABLE STRUCTURE FOR: tec_categories
#

DROP TABLE IF EXISTS `tec_categories`;

CREATE TABLE `tec_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(55) NOT NULL,
  `image` varchar(100) DEFAULT 'no_image.png',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_categories` (`id`, `code`, `name`, `image`) VALUES ('1', '1', 'Limpeza', '5c9b448f7b2dced36d122a963101a849.jpg');
INSERT INTO `tec_categories` (`id`, `code`, `name`, `image`) VALUES ('2', '4', 'Bebidas', '074b51decf7e76adf05284a26f6d3c8d.jpg');
INSERT INTO `tec_categories` (`id`, `code`, `name`, `image`) VALUES ('3', '3', 'Diversos', '2733676bb72c83f50fa48f1579eea5e4.png');


#
# TABLE STRUCTURE FOR: tec_combo_items
#

DROP TABLE IF EXISTS `tec_combo_items`;

CREATE TABLE `tec_combo_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `quantity` decimal(12,4) NOT NULL,
  `price` decimal(25,2) DEFAULT NULL,
  `cost` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_customers
#

DROP TABLE IF EXISTS `tec_customers`;

CREATE TABLE `tec_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `cf1` varchar(255) NOT NULL,
  `cf2` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `endereco` varchar(555) NOT NULL,
  `numero` varchar(20) NOT NULL,
  `complemento` varchar(255) NOT NULL,
  `bairro` varchar(255) NOT NULL,
  `cep` varchar(100) NOT NULL,
  `cidade` varchar(100) NOT NULL,
  `estado` varchar(100) NOT NULL,
  `obs1` varchar(2222) NOT NULL,
  `data` date DEFAULT NULL,
  `Country` varchar(255) DEFAULT NULL,
  `AccountID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=779 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('2', 'José Manuel Barros', '003136359BA034', '', '991859340', 'mactos.barros@hotmail.com', 'Bairro 28 de marco ', '433', 'Benguela', 'Bairro 28 de marco ', '2', 'Bairro 28 de marco ', 'Benguela', '', '2020-08-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('3', 'Wiliete Crédito, lda', '5111050027', '', '947952438 | 93140002', '', 'Rua: Aires de Almeida Santos', '0', 'Rua: Aires de Almeida Santos', 'Rua: Aires de Almeida Santos', '2', 'Benguela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('11', 'Clima Puro Lda', '5111050655', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('13', 'imogestin sa', '5401039603', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('15', 'Tecnoconsult', '5111031790', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('17', 'Refrima Comercio e Servicos (Su) Lda', '5000653756', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('18', 'Strret Limpa Lda', '5111050302', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('19', 'Bibzi-Gestao-Servicos lda', '5417142433', '', '', '', '1', '', '1', '1', '2', 'Benguela', 'Benguela', '', '2021-07-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('20', 'BAI', '5410000510', '', '', '', '1', '', '1', '1', '2', 'Benguela', 'Benguela', '', '2021-07-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('21', 'Happy Flowans', '5111045309', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('22', 'Tojo e Seny Corporation Lda', '5111048618', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('23', 'Antex .Angola ', '5401058705', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('25', 'Organizacoes  pembati', '5111039449', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('29', 'Vertical Limitada', '5111043470', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('30', 'casa caala', '5111037985', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-07-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('34', 'Organizacoes framita', '5111001972', '', '', '', '1', '', '1', '1', '2', 'Benguela', 'Benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('36', 'Escola Gustave Eiffil Lda', '5112014377', '', '', '', '1', '', '1', '1', '2', 'Benguela', 'Benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('38', 'Antonio Pinto de Sousa Limitada', '5111000488', '', '', '', '1', '', '1', '1', '2', 'Benguela', 'Benguela', '', '2021-08-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('40', 'Paulo Editora', '006022695HA041', '', '', '', 'Rua Avenida Dr . Agostiho Neto', '', 'Rua Avenida Dr . Agostiho Neto', 'Rua Avenida Dr . Agostiho Neto', '2', 'benguela', 'benguela', '', '2021-07-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('42', 'Green Island', '5000547085', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('43', 'Tchimbali  Comercial lda', '5417049816', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('44', 'Instituto Nacional  Seguraca Social', '5000344583', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('47', 'Colegio Bueia Filhos', '5111040587', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('48', '3z Sucata Angola Lda', '5417145424', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('51', 'Projest Lda', '5403084134', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('52', 'Benguela Construcoes', '5111029184', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('54', 'A sombra lda', '5111039503', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('56', 'maguerinha', '5111039559', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('57', 'Manguerinha ', '51110395889', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('58', 'Corma Lda ', '5111000690', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('64', 'Octane comercial Lda', '5417570443', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('65', 'Clinica Medica de Especialidade e Diagonostico', '5111050574', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('68', 'ICAP', '5000388653', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('70', 'aldeia  sos', '5000369365', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('71', 'Suzadany', '5111044019', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('72', 'farmacia  acacia', '5401133065', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('73', 'Feira de Tecido', '5402127697', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('74', 'R T U', '5111052216', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('75', 'PRODEL EP', '00000000087500', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('77', 'Farmacia Ambrofarme Lda', '5000083615', '', '923759463', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('78', 'Tudo Na Brasa', '5111045058', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('79', 'N D O G V', '5000397733', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('80', 'Rio Lombo Comercial ', '5417349534', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('83', 'Fazenda M Umba', '5417235601', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('84', 'Marcos Victor Jorje Valente', '002841450BA038', '', '', '', 'benguela', '', 'benguela', 'benguela', '2', 'benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('85', 'Carrinho Empreendimentos S.A', '5112001259', '', '924077296', '', 'Lubito Bairro da luz ', '', 'Lubito Bairro da luz ', 'Lubito Bairro da luz ', '2', 'Benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('86', 'B P C', '541000552', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('87', 'Innovia', '5401150563', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('89', 'O Plantao  S.A', '5402123420', '', '', '', 'Talatona/ Luanda', '', 'Talatona/ Luanda', 'Talatona/ Luanda', '2', 'Talatona', 'Benguela', '', '2021-10-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('91', 'MANASIL LDA', '54002126925', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('93', 'Dar  ANGOLA ', '5402103259', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('95', 'Radio Benguela', '5000001716C', '', '', '', 'AV 1o de fevereiro', '', 'AV 1o de fevereiro', 'AV 1o de fevereiro', '2', 'Benuela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('96', 'Xadu', '5111033696', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('97', 'Unique Beveragues SA', '5417294039', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('98', 'Hotel Residencial Benguela', '5402155526', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('99', 'Novibronds Comercio e Servicos', '5417650900', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('100', 'Aredalmar', '5112159588', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('101', 'Socipesca Lda', '51110220721', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('102', 'FERTIAFRICA COM.E INDUSTRIA DE FERTILIZANTES. SA', '5417660396', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('103', 'Espaco Angola', '5401132271', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('104', 'Distrigood', '5402155682', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('107', 'NOBLE GRUPO ', '5417181641', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('108', 'muticojex', '5417198790', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('110', '2  KTECH LDA', '5417362077', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('111', 'MAIS VET    SERVICO  VETERINARIO ', '5000506079', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('112', 'Noveduca', '5417296856', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('113', 'Angomekseb', '5000594490', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('114', 'Dez Martins', '5403050442', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('115', 'Colegio Sessa', '5111045848', '', '923689337', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('116', 'E P A S B - EP', '5111040641', '', '', '', 'Rua Sacadura Cabral nº122', '', 'Rua Sacadura Cabral nº122', 'Rua Sacadura Cabral nº122', '2', 'Benguela', 'Benguela', '', '2022-07-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('119', 'SHOWBUSINESS', '5111054650', '', '929383293', '', 'Vilas Das Acacias  Benguela', '', 'Vilas Das Acacias  Benguela', 'Vilas Das Acacias  Benguela', '2', 'Benuela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('120', 'Condominho Acacias Place', '5111048472', '', '929591355', '', '', '', '', '', '2', 'Benuela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('121', 'Luanday', '5417010871', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('122', 'A N N A Lda', '5401116098', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('123', 'kalussipa', '5112161744', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('124', 'Gepe ', '5000449644', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('125', 'Nezel Service Lda', '5000523895', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('126', 'COMPUTEL,  LDA', '5111052267', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('127', 'Mediag Analises Clinicas', '5401165340B', '', '', '', 'Rua Tomas Vieira da Cruz', '', 'Rua Tomas Vieira da Cruz', 'Rua Tomas Vieira da Cruz', '2', '', 'Benguela', '', '2021-08-24', 'An', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('129', 'TECNOCONTROL', '5117002385', '', '', '', '00', '', '00', '00', '2', 'Benguela', 'Benguela', '', '2021-08-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('131', 'Gayzo comercio Lda', '5000232424', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('132', 'Gu Frio Lda', '5111050515', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('133', 'Jeronimo Jose Escola De Comducao', '001314636BA036', '', '923869024', '', 'Bairro Da Graca', '', 'Bairro Da Graca', 'Bairro Da Graca', '2', 'Benuela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('136', 'JB Aluminio', '5111046534', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('137', 'elecnor ', '5402106223', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('138', 'Dason Lda', '5111046100', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('139', 'transgida limitad', '5111041788', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('140', 'Deline Grill', '000418124BA041', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-08-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('143', 'ADRA', '5000077623', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('144', 'Facra', '5000358177', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('145', 'salinas    calombolo', '5111050612', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('146', 'ANGOLA    DAPIG', '5401184689', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('149', 'HOTEL     DUAS    FACES', '4111046429', '', '', '', '0', '', '0', '0', '2', 'Benguela', '0', '', '2021-08-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('152', 'auto william', '5000539376', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('153', 'srep', '5000574929', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('154', 'ozango minerais s.a', '5417174149', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('158', 'ES MR COMERCIO', '5000604534', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('159', 'Instituto Nacional de Estatistica', '7401015315', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('160', 'fazenda Agro Pecuaria utalala Lda', '5000170879', '', '', '', 'Dr. Antonio Jose De Almeida Nº95', '', 'Dr. Antonio Jose De Almeida Nº95', 'Dr. Antonio Jose De Almeida Nº95', '2', 'Benguela', 'Benguela', '', '2021-08-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('162', 'Ution     TECNOLOGIA', '500000', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('163', 'UTION    TECNOLOGIA', '5000009792', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-08-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('164', 'Ango Real', '5405162884', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('165', 'I S P OMBAKA', '511104938', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('166', 'Frepa Lda', '5111052704', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('167', 'PASTELARIA      EL   FLAMINGO', '006234624OE41', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('169', 'SINFIC    CENTER', '5171093725', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('173', 'H E L', '5112142880', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('174', 'ACK -GAMES', '541755047A', '', '', '', 'Domingos Do O', '', 'Domingos Do O', 'Domingos Do O', '2', 'Benuela', 'Benguela', '', '2021-09-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('176', 'B.A.B', '5111038175', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('180', 'Mario Monteiro', '000003711937032', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('181', 'KWANZA CORP', '5151013556', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('182', 'EVOLUTION', '5417316261', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('183', 'UMBUESSA     COMERCIAL', '5111028366', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('184', 'JOTASIL     LDA', '5111022783', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-09-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('186', 'tchatena', '5111050418', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('188', 'azeqque comerco prestaceos de servico', '5000635006', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('195', 'LILIANA   DIAS   FILHO    LDA', '5117001150', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('196', 'peixaria  ombisi   yetu', '5111040714', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('197', 'JBM', '5112142405', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('198', 'TOMBOSY', '5111039058', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('199', 'SOT   LDA', '50001139872', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('200', 'SPRIT', '5402111855', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('201', 'RCAN     LDA', '511104976', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('202', 'CME- ANGOLA', '5403104208', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('206', 'HL-DESIGEN', '5111043799', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('208', 'SST', '5111039791', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('210', 'E-VULUTION', '004676291', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('213', 'SISTEC   S.A.', '5410002547G', '', '925362227', '', 'Rua Sacadura Cabral, 104 B\\C- Benguela', '', 'Rua Sacadura Cabral, 104 B\\C- Benguela', 'Rua Sacadura Cabral, 104 B\\C- Benguela', '2', 'Benuela', 'Benguela', '', '2021-09-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('215', 'BENJA. BK', '5000424773', '', '', '', 'Rua direita das Bimbas', '', 'Rua direita das Bimbas', 'Rua direita das Bimbas', '2', 'Benuela', 'Benguela', '', '2021-09-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('217', 'SERRA     DA     LEBA', '5111008306', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('218', 'LBLA    LOUSI   LDA', '5000185540', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('220', 'SOCIFARMA', '5401172486', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('223', 'IVO   BEPHOVEN', '000000021518', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('225', 'Quiwany Lda', '5111050094', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('226', 'gota pura lda', '5417187364', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('227', 'colegio wlhiete', '5111045287', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('228', 'carliz.rolamento', '5480018965', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('229', 'Aarnext', '5417539660', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('230', 'EMAXICOM LDA', '5410001001', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('233', 'SIGMATIC ANGOLA', '5417294322', '', '', '', 'LUANDA', '', 'LUANDA', 'LUANDA', '2', 'VIANA', '', '', '2021-09-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('234', 'Prosis SA', '5417049573', '', '', '', 'Rua Amilcar  cabral,Predio nº 27 S\\L', '', 'Rua Amilcar  cabral,Predio nº 27 S\\L', 'Rua Amilcar  cabral,Predio nº 27 S\\L', '2', '', 'Benguela', '', '2021-11-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('235', 'S S A B LDA', '5417265861', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('237', 'IP4U', '5403109579', '', '', '', 'Nova vida rua 14 nº46', '', 'Nova vida rua 14 nº46', 'Nova vida rua 14 nº46', '2', 'LUANDA', 'LUANDA', '', '2021-09-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('238', 'TCHICAMBY      LDA', '5112162163', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('239', 'P. A MARIA NAHEVE', '001445575BA035', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'B', '', '2021-09-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('240', 'EDIKRIN PRESTACAO DE CERVICO LDA', '5111054308', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('241', 'GUANDA PESCA', '54800313131', '', '', '', 'VILA DA CAOTA', '', 'VILA DA CAOTA', 'VILA DA CAOTA', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('242', 'CARROLUXUO', '5000011126', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('243', 'NDOGV', '5000393377', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('245', 'INOTU BENGUELA', '5000355356', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('246', 'URBIPEDRA     LDA', '5417011193', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('247', 'CEIEC ANGOLA LDA ', '5403109501', '', '', '', '8º PISO METROPOLIS MAIANGA LUANDA', '', '8º PISO METROPOLIS MAIANGA LUANDA', '8º PISO METROPOLIS MAIANGA LUANDA', '2', 'Benguela', 'Benguela', '', '2021-11-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('248', 'PCS  NET', '5112163429', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('249', 'CADINOS,   LDA', '5111039937', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('251', 'IGAE', '5000389331', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('252', 'Instituto Politecnico UKB', '5000345865', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('253', 'FALKAT', '5417142565', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('254', 'A.G.T-Quarta Regiao Tributaria', '5000334740', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('255', 'KURBAN LDA', '5112163933', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('257', 'TELHABL,  CONSTRUÇOES  ANGOLA ,  S.A.', '5191012690', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('258', 'F. A. P.  SULU.  LDA', '5111042059', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('259', 'MARJODY', '5111039864', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('260', 'B PC   AGENÇIA   NAVEGATES', '54140000552', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('262', 'TOMAS    DE   OLIVEIRA', '5111013024', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('263', 'video vigenlencia', '2111092662', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('264', 'construik lda', '5417025844', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('265', 'Cario', '5111052399', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('266', 'Ndaty shipping', '5112159545', '', '923448359', '', 'Lubito', '', 'Lubito', 'Lubito', '2', '', 'Benguela', '', '2021-09-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('267', 'Padaria Kimvan', '5111040498', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('268', 'MADEIRARTES    LDA', '5111043942', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('269', 'JTI', '5000141976', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('270', 'RPED    ANGOLA', '5484004705', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('271', 'ELECTO    AFRICA     LDA', '5111001085', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('272', 'NAVAL      COMERCIAL', '5417042501', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('275', 'inn comercio indudria lda', '5417005134', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('276', 'jodisil lda', '5111051295', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('280', 'Edlisa', '5000400211', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('282', 'Restaurante Alcamar', '5112160632', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('284', 'SEIP-Infrastrutura e Construcoes, Lda', '5401145969', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('288', 'EDIÇOES     NOVEMBRO   -EP', '5401113579', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('289', 'fazenda bacelinho', '5417329690', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-09-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('292', 'HERCAY', '5111038132', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('293', 'MERSUS', '5604006084', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('294', 'TRANSCOP INDUSTRIA', '5111040951A', '', '', '', 'BAIRO CAMUNDA RUA DO MUNDO BAR', '', 'BAIRO CAMUNDA RUA DO MUNDO BAR', 'BAIRO CAMUNDA RUA DO MUNDO BAR', '2', 'Benuela', 'Benguela', '', '2021-10-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('296', 'DELINE      CAFE', '0006234624OE41', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-10-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('298', 'J  J   LDA', '5000267287', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('299', 'FAS   BENGUELA', '7401001039', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('302', 'JOSE LUIS DE CARVALHO LD', '5111000046', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('304', 'IM-CATIMBA', '5000509728', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('305', 'Oliveira e Ligeiro Lda', '5111027556', '', '', '', 'Rua Doctor Antonio jose de Almeida', '0', 'Rua Doctor Antonio jose de Almeida', 'Rua Doctor Antonio jose de Almeida', '2', 'Benuela', 'Benguela', '', '2021-10-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('306', 'PHARMA VIDA LDA', '5111045317', '', '', '', 'RUA MACHADO DOS SANTOS CASA Nº1', '', 'RUA MACHADO DOS SANTOS CASA Nº1', 'RUA MACHADO DOS SANTOS CASA Nº1', '2', 'Benuela', 'Benguela', '', '2021-10-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('307', 'Transpacifico Lda', '5417670340', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('308', 'williete Benguela', '5000121754', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('309', 'TAIJEC', '5111041345', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('311', 'J.M.2.X', '5111045546', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('312', 'PAULO   ALVES   LDA', '5111047590', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('313', 'CAB  -CONSUITORES    REUNIDOS   LDA', '5401146507', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('314', 'ESCOLA DE CONDUCAO', '5111044361', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('315', 'VIERA PEIVA', '5111042202', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('316', 'MECOFARMA DE ANGOLA', '5401127251', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('317', 'LISMAV CONSULTING LDA', '5111054430', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('318', 'CASA-FE', '5111041028', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('319', 'Momente  Day Spa LDA', '5111050680', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('320', 'O I C', '5000348074', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('321', 'Elsama lda', '5111046038', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-10-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('322', 'OFECIF', '5111041281', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('324', 'REDES    CORDAS LDA', '5000440523', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('326', 'AJS', '5000350532', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('327', 'Aluminio Benguela', '5111042245', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('328', 'C C J LDA', '5111042504', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('329', 'kel & CriS', '5111049770', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('330', 'ERMALINA', '5111053913', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('331', 'YE. XL', '5000123030', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('335', 'ESCOLA DE CONDUCAO SIJOMA LDA', '5111023445', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('338', 'E  A S L ', '5112000090', '', '', '', 'CANATA', '', 'CANATA', 'CANATA', '2', 'LUBITO', 'Benguela', '', '2021-10-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('339', 'MIRRTEC {SU} LDA', '5117002474', '', '', '', '0', '0', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-10-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('341', 'CINCO CENTIDOS -FILIAL  BENGUELA', '5417042994B', '', '', '', 'PDIC', '', 'PDIC', 'PDIC', '2', 'Benuela', 'Benguela', '', '2021-10-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('342', 'MARY MAREB', '5171162328', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('343', 'GLS   HOLDING S.A', '5403114289', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('345', 'FrutiGel', '5111030421', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('346', 'SALOMAO', '5000418919', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('347', 'COLEGIO    ELIZAJELA', '5111149673', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('348', 'MKOA', '523254831', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('349', 'LOCOMAGUE     CONSTRUÇOES    LDA', '5417066095', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('350', 'BANCO SOL', '5410000579', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('351', 'SOCORRO-PROTECCAO DE SEGURANCA ', '5403079050', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('352', 'COLEGIO DE BENGUELA', '5417183814', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('355', 'FINIBANCO     ANGOLA', '5403105131', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('356', 'D  N T. ANGOLA', '5171167052', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('357', 'poliobra construcoes', '5111043160', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-10-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('358', 'SEDE. URBANIZACAO NOVA', '5417003573', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('359', 'FONSECA IRMAO', '511003703', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('361', 'E F T P SAUDE P. DAMIAO', '5112160012', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('362', 'OIL CENTER', '5111040439', '', '', '', 'Rua Dr. Agostinho Neto', '', 'Rua Dr. Agostinho Neto', 'Rua Dr. Agostinho Neto', '2', 'Benuela', 'Benguela', '', '2021-11-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('364', 'Aldeia S.O.S', '5111039074', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('365', 'ELECTRO .    SUL', '5111023470', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('367', 'CAT,SA', '5162004685', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('368', 'Casa Lubito', '5112164875', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('369', 'IT ANGOLA', '5417425613', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('370', 'S I C E', '5403079270', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('371', 'Aligel Lda', '5417093157', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('372', 'TINO GUTIEER ENJINHARIA', '5000482510', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('374', 'FILJESS COMERCIO E SERVICO LDA', '5000417041', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('375', 'TECNISILVA LDA', '5111054545', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('376', 'Sociedade Agricola das Bimbas Lda', '5000033600', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('377', 'INEFOP', '5000282570', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('379', 'REPINTA LD', '5112000309', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('380', 'H M S', '5000818810', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('381', 'CACIMBO', '5417167444', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('382', 'NORAFRICA', '5403086609', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('383', 'ragasso', '5111054391', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('384', 'LAPJ-contablidade lda', '5000170224', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('385', 'P-A   1 de MAIO', '511040439', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-11-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('386', 'INACOM', '5000354643', '', '948480533', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-11-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('387', 'EMINANA   SERVIÇO  LDA', '5000150100', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('388', 'VICTORIA    ORIETAL', '5417549207', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('389', 'U.K.B  F.DEDIREITO', '5000345873', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('390', 'C.KIAME', '5402155240', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('392', 'TINTAS     CIN   DE    ANGOLA', '5403076425', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('393', 'MSTELCOM', '5410003578', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('394', 'TANIA MENDONCA', '005242346BA048', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'B', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('395', 'C R B', '5000469394', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('396', 'UKB REITORIA', '5000345822', '', '', '', '00', '', '00', '00', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('397', 'C.A.B S.A', '5111044980', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('398', 'ETERNA', '5111026827', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('399', 'CADEADO SEGURO', '5000221856', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('400', 'Eletro Paiva', '2111080446', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('401', 'SONIT INTERNACIONAL', '5401162600', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('403', 'ANGOP', '5000390135', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('404', 'MARIO MILITAL MOTEIRO', '5111052313', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('405', 'DDM', '5401123833', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('406', 'JOKABA LDA', '5111041729', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('407', 'JEANANT-LDA', '5000119342', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('408', 'siluz lda', '5403083529', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('409', 'SEDE LDA', '5111000666', '', '', '', '10º DE DEZEMBRO', '', '10º DE DEZEMBRO', '10º DE DEZEMBRO', '2', '', 'Benguela', '', '2021-12-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('410', 'BENGUELA MOVEIS LDA', '5111047123', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('413', 'EDT', '5403099670', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('414', 'PRINCE FARMA', '5417070858', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('415', 'T D G I', '5402107998', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('416', 'I D F', '7171009165C', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2021-12-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('417', 'VERA  NOVA', '5403089888', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('418', 'NOVA FUMENTAL LDA', '5000797634', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('421', 'WLAMAR SOCIEDADE IMOBILIARIA LDA', '5419006693', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('423', 'LOGUENBIA', '5111039090', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('424', 'LOBINET', '5112142294', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('426', 'largo desenvolvimento ', '5000345270', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('427', 'BIOGESP LDA', '5111049347', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('428', 'BOA VISTA', '5000336076', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2021-12-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('429', 'RIKAUTO COMERCIO INDUSTRIA LDA', '5402126380', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('430', 'S E LOGISTICA', '5417261610', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('431', 'ALIANCA C.T COMERCIO E SERVICO LDA', '5000913480', '', '923385642', '', 'BºPARQUE ECA DE QUIROZ-BENGUELA', '', 'BºPARQUE ECA DE QUIROZ-BENGUELA', 'BºPARQUE ECA DE QUIROZ-BENGUELA', '2', 'Benuela', 'Benguela', '', '2022-06-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('432', 'RAINHA DE COPA', '005928820BA049', '', '', '', 'BAIRRO DOCOTA', '', 'BAIRRO DOCOTA', 'BAIRRO DOCOTA', '2', '', 'Benguela', '', '2022-01-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('433', 'WORK LIMP SERVICE LDA', '5000166022', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('435', 'BEZIBEZI', '5417055786', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('436', 'I G  I   P', '5402020957', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('437', 'PLORALIA', '5417144592', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('439', 'MACON  TRANSPORTE S.A', '5410003250', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('441', 'CAMOC ANGOLA LDA', '5417059820', '', '', '', 'RUA MAJOR KANHANGULO INGOBOTA', '', 'RUA MAJOR KANHANGULO INGOBOTA', 'RUA MAJOR KANHANGULO INGOBOTA', '2', 'LUANDA', 'Benguela', '', '2022-01-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('442', 'PESCA     FRESCA', '5111033548', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('443', 'ERMAS MONGE', '005978038BE040', '', '', '', 'BIE, CUITO', '', 'BIE, CUITO', 'BIE, CUITO', '2', '0', 'Benguela', '', '2022-01-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('444', 'FLO-TEK', '5405026603', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('445', 'TAAG LINHAS AERIAS DE ANGOLA', '5410002830E', '', '', '', '0', '', '0', '0', '2', 'Benuela', 'Benguela', '', '2022-01-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('447', 'CONSNAVAL LDA', '5112159014', '', '', '', 'BºDA FRONTEIRA', '', 'BºDA FRONTEIRA', 'BºDA FRONTEIRA', '2', 'Benuela', 'Benguela', '', '2022-01-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('448', 'H S LDA', '5000073407', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('450', 'MIREX', '5000377198', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('451', 'TOHOMBELA       PSIQUE', '5000739685', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('452', 'VIEIRA     E  FILHO   LDA', '5111014136', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('454', 'STARGO LDA ', '5417388955', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('455', 'SOCET', '5111039872', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('457', 'LOUREIRO    SA', '5111008730', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('460', 'P.   I   .    D.    PROVINDENCIA', '5000190870', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('462', 'TALHO GUERRREIRO  E FILHO LDA', '5111050868', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('464', 'GRUPO C-A-B. SA', '5111044981', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('465', 'HOTEL NAVEGANTE LOBITO', '5401152841', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('466', 'S G A', '5410001044', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-01-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('468', 'QUER OBRA', '5417069710', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('471', 'ENOC CUTEQUILA', '1007022694LA049', '', '', '', 'BAIRRO DO CALOMBURACO', '', 'BAIRRO DO CALOMBURACO', 'BAIRRO DO CALOMBURACO', '2', '', 'BENGUELA', '', '2022-01-29', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('472', 'DIOSESSE DE BENGUELA', '5000345008', '', '', '', '00', '', '00', '00', '2', 'Benguela', 'Benguela', '', '2022-02-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('474', 'MARTINS E NEVEL', '5111040463', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('475', 'FARMACIA YOLELA SUCURSAL', '001578754BA039', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-02-04', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('476', 'PORTA    AVIOES', '5101136951', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('477', 'ROSALINA EXPRESS', '5112165766', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('480', 'FAZENDA EURICO LOPES DE ALMEIDA', '5111040080', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('481', 'PSI', '5000338281', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('482', 'AUDI-CONTABIL LDA', '5112160381', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('483', 'VEDWIN', '5417488526', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('484', 'EKFM COMERCIAL', '5111051317', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('485', 'VIDA CABELOS', '5417452351', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('486', 'RONAK FARMA', '5000811955', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('490', 'GALAR     CONSTROI', '5417040622', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('491', 'AGT', '5000393533', '', '', '', 'LUANDA', '', 'LUANDA', 'LUANDA', '2', 'LUANDA', 'LUANDA', '', '2022-02-16', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('494', 'STOR INTERNACIONAL', '5111048731', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('495', 'Tecben', '5111019197', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('496', 'SOCI PESCA LDA', '5111020721', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('498', 'CRIANÇA       FELZ', '5000664766', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('499', 'SINOHYDRO  CORPORATIN LDA', '5401140967', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('500', 'O R M', '000106099BA037', '', '', '', 'BENGUELA', '', 'BENGUELA', 'BENGUELA', '2', 'BENGUELA', 'BENGUELA', '', '2022-02-25', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('501', 'J.L- JOSE  LOPES,SU   LDA', '5000430790', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-02-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('502', 'CLESE', '5000347525', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-02-28', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('503', 'BRINDE LAR LDA', '511027173', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('504', 'ANGOPRI', '5112158859', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('505', 'HUILA DESIGN', '5171093610', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('506', 'Yazinara Pestana Lda', '5000700720', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('507', 'PONTO ALIMENTAR', '5111046941', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('508', 'P.A OBELISCO', 'AO5410003764', '', '', '', 'LOBITO', '', 'LOBITO', 'LOBITO', '2', 'LOBITO', 'BENGUELA', '', '2022-03-03', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('509', 'JM2X', '5111045540', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('510', 'J.F.S, LDA', '5417068470', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('511', 'I.N.E', '5000321230', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('512', 'MARIA ALICE ', '005019966BE041', '', '', '', '0', '', '0', '0', '2', '0', 'B', '', '2022-03-06', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('513', 'F F. PRESTACAO DE SERVIÇOS ', '002546377LA038', '', '', '', 'BAIRRO SAO JOAO', '', 'BAIRRO SAO JOAO', 'BAIRRO SAO JOAO', '2', 'BENGUELA', 'BENGUELA', '', '2022-03-06', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('514', 'URBALUX S.A', '5419007576', '', '', '', '0', '0', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('515', 'GRUPO RPA E FILHOS LDA', '5117243507', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('516', 'FUTURO FLORECENTE COMERCIO E SERVIÇO', '5000957780', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('517', 'FARMACIA KUDISSANGA', '5601009902', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('518', 'ACAP CONSULTORIA ', '5111053751', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('520', 'OMOLA WENE FARMA', '5000448311', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('521', 'HEUREUX GESTAO E SERVICOS LD', '5000088749', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('522', 'G.T.S.- COMERCIAL', '5112158220', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('523', 'PENSAO FILIPA LDA', '511105056', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('524', 'RIASIL  ', '5410002326B', '', '', '', '0', '1', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-09-12', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('525', 'PALMENTAR', '5000048097', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('528', 'JOMOTA    COMERCIAL', '5111028072', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('529', 'UNICA    FARMA', '5417401404', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('530', 'HOTEL  LUZO', '5111052372', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('531', 'P. J ESTIVA LDA', '5417126535', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('532', 'BETACAND ENG, LDA', '5417241067', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('534', 'ADAO MOTA DA SILVA', '5402033943', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('535', 'TRIANGOLAR ', '5111040676', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('536', 'INSTITOTO      SUPERIOR    POLITECNICO     OMBAKA', '5111049380', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('537', 'EMMI', '5401143214', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('538', 'MANGO COMERCIAL', '00294646004', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-03-28', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('539', 'AZZUL PISCINAS', '5417000698', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('540', 'JONGOLA ', '5417207950', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('541', 'MULTITEP SERVICOS DE TELECOMUNICACOE LD', '5401127294', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('542', 'SOCIEDADE AGRICOLA DE MOVEIS', '5111000445', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('546', 'ENCEL CONSTRUÇOES ELECTRICAS', '5402005788', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('547', 'BIOPREV', '5417140600', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('548', 'O R M', '002842689BA033', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-03-30', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('549', 'Organizaçoes  Mon Don', '5401156340', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-03-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('550', 'PITRUCA PRESTACAO DE SERVICO', '5402135797', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('552', 'FARWELL', '5401091613', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('555', 'HIPER PROTEÇAO ', '5171093822', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('556', 'GELSON', '5000027294', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('557', 'MALAQUIAS UCANDI', '003008909BA039', '', '', '', '0', '', '0', '0', '2', 'LUBITO', 'BENGUELA', '', '2022-04-03', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('558', 'PRIMEIRA A POSTA', '5000448387', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('560', 'iguana comucacaes', '5417669105', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('561', 'AN LIANG INTERNACIONAL', '5111043020', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('562', 'WAFAZT', '5417523402', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('563', 'HOILUX', '5112145323', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('564', 'FGS', '5401186320', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('565', 'PEP      ANGOLA     LDA', '5417029343', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('567', 'TEL CONTAS LDA', '5111054316', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('568', 'IGAPE', '5000272396', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('569', 'SM KANSO LDA', '5000083860', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('570', 'tecnasol', '5401143389', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('571', 'joelson', '5111030468', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('572', 'porbenguela', '5417094579', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('573', 'AVIARIO BICO D OURO', '511101855', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('574', 'NANCY ENGLISH SCHOOL', '5417064920', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('575', 'COSAL MAQUINAS LDA', '5112149809', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('576', 'JOAO  GALVAO ', '5111050787', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('577', 'ANGO-PHARMAKA', '5000103837', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('578', 'SENECACH E FILHOS LDA', '5901022009', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('579', 'LACOTINGO ANGOLA LDA', '5401152060', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('580', 'E.K.F.M COMERCIAL LDA', '5111051371', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('581', 'FERTE ANGOLA', '5117001010', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('582', 'EDUARDO', '001312392KS037', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-04-14', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('583', 'ADPPPROJECTO    COMUNITARIO  VIH/ SIDA-TB', '5000344354', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('587', 'NEWACO GRUPO', '5417196568', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('588', 'CELESTEL TELECOMUNICACOES LDA', '5111044213', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('589', 'CPE-BENGUELA', '7111003764', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('590', 'XELA', '5401123485', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('591', 'FLOR DO SUMBE', '5601000140', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('593', 'F.F.', '002546377038', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('594', 'CASAIS ANGOLA ENGENHARIA ', '5401043821', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('595', 'alves  irmaos', '5112000589', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('596', 'tendencia', '5111043349', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('598', 'NXN', '5111045953', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('599', 'HOTEL', '5111038949', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('600', 'DOUROS  ,    LDA', '5417660736', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-04-29', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('601', 'JW BRAZ', '5000427764', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('602', 'GCM', '5000786586', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-04-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('603', 'SACUTOMBI', '004603215BA049', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-05-02', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('604', 'ACDC', '5111038230', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('605', 'LHLC.LDA', '5011048952', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('606', 'FINOSIDRUGIA--COMERCIO   E  INDUSTRIA', '5000867101', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('607', 'QUINTA  DO  FOMEIRO   BENGUELA', '005759141', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('608', 'WOOS INTERNATIONAL COMPANY', '512200724', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('609', 'H S', '5417003166', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('610', 'abjul e filhos lda', '5112149965', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('611', 'ESCOLA DE CONDUÇAO AUTO TRALING', '5111040013', '', '', '', 'DR.ANTONIO AGUSTINHO NETO', '', 'DR.ANTONIO AGUSTINHO NETO', 'DR.ANTONIO AGUSTINHO NETO', '2', 'BENGUELA', 'BENGUELA', '', '2022-05-05', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('612', 'AFRICA PHARMACY', '5401135173', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('614', 'CASA NATURA', '5405160105', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('616', 'yasso', '5000402583', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('617', 'Jacobesons Su Lda', '5000535400', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('618', 'PANI BOM', '5111016368', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('619', 'A J COMERCIAL', '5111047301', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('620', 'pitruquinhas', '000325611035', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('621', 'Angolaca ', '5411000386', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('622', 'AFONSO LUZA SU LDA', '5000692433', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('623', 'CND', '5410001826', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('624', 'FONSECA  IRMAO INDUSTRA', '5111004289', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('625', 'EMPRESA -TERPONTE ', '5111041699', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('626', 'nkhole investimento ', '5111049630', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('627', 'BANCO   NACIONAL', '5000380849', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('628', 'ILIK DESIGN LDA', '5112163704', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('629', 'DHSC', '5000906301', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('630', 'hidroplanaito lda', '5417273651', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-16', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('631', 'JOSE MANUEL RAMOS', '002934221BA030', '', '', '', 'B', '', 'B', 'B', '2', 'BENGUELA', 'BENGUELA', '', '2022-05-18', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('632', 'NAIPE LDA', '5111002561', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('634', 'Dilma Comercial', '001134831033', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('635', 'A.S.D.M  LDA ', '5000707163', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('636', 'VPN CONSULTOREA LDA', '5111054669', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('637', 'C.S .E BENGUELA E ASSOCIADOS LDA', '5111023135', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('638', 'DATALOG LDA', '5112164344', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('639', 'PONTO CERTO', '5112161329', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('640', 'INTER CLUBE', '5000381144', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('641', 'ASSOCIAÇAO FLAMINGO', '7401020360', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('642', 'LE VAN VUONG', '2111108812', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('643', 'HUAMBO EXPRESSO', '5000576832', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('644', 'AGT', '5000344370', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('645', 'MAIS-VERDE LDA', '5111048120', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('646', 'I.C.C', '5402140014', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('647', 'ANGO PLASTICO SA', '5171002894', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('648', 'BRISA DA RESTINGA LDA', '5000456748', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('649', 'CASANOVA', '5403110275', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('650', 'I.S.U.M', '5111047239', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('651', 'DESENVOOLVE LDA', '5111040250', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('652', 'ANFIRIS LDA', '5112159138', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-05-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('653', 'ANGOLA TELECOM', '5410000323', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('654', 'LIGEIROS COMERCIOS E SERVIÇOS LDA', '5000619124', '', '', '', 'RUA PRAÇA DA REPUBLICA', '', 'RUA PRAÇA DA REPUBLICA', 'RUA PRAÇA DA REPUBLICA', '2', 'BENGUELA', 'B', '', '2022-06-01', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('655', 'JOCAUTO', '5111043268', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('656', 'ATLALAS GRUPO', '541000047', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('657', 'WISEA LDA', '5111051619', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('658', 'CAALA SOLUCOES LDA', '5000772984', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('659', 'ANGOERI', '5403084622', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('660', 'Aldeia  Nova', '5417124788', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('661', 'Equipa de Ciclismo de Benguela', '5111042300', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('662', 'LP 2S', '5000189200', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('663', 'NANKAVA  E SODRE', '5000500402', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-05', '0', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('664', 'Instituto Angolana do RIM ', '5417096563', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('665', 'Instituto medio industrial de benguela', '5000343641', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('666', 'Pescaria Mormolo', '5111004408', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('668', 'FRONEXT COMERCIO GERAL SU LDA', '5417589349', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('670', 'CONS-TECNO', '5417612081', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('671', 'ISAIAS   BENTO  CANDIEIRO', '002084484032', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-08', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('673', 'JGA', '5000049972', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('674', 'ETUNDILO SU LDA', '5000014273', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('675', 'POWERGOL', '5401174799', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-10', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('676', 'ALVA   FISHING', '5111024433', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('677', 'TWENDY   KUMOSY', '5000603902', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('678', 'PLANASUL', '5171017360', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('679', 'moda carlos', '001380515037', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('680', 'SUGE INTERNACIONAL', '5417032018', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('681', 'LOBINAVE', '5112000759', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('683', 'EDNA   TCHIPOIA', '5000038091', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-20', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('684', 'AGT QUARTA REGIAO TREBUTARIA ', '5000334047', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('685', 'YIWEI PRESTACAO DE SERVICO LDA', '5000166570', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-22', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('686', 'POLISIFI.   LDA', '5417091901', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('687', 'D. PEREIRA LDA', '5117001044', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('688', 'AMAZING', '5000166480', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-24', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('689', 'AFRITECTOS', '511105000', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('690', 'CALMITO LDA', '5111009426', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('691', 'PIS-ENG-CONSTRUCAO LDA', '5112159456', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('692', 'CONGELE', '5111041354', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('694', 'ABC- COSMETICS', '5417402010', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-06-29', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('696', 'ARMANDO DE FREITA RAMOS, LDA', '5111050477', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('697', 'SANDRO GOSALVES INVESTIMENTO', '5000546755', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('698', 'GOLD CAR', '5112161523', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('699', 'KFC', '5417112097', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('700', 'AEDI', '5000260517', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('701', 'TRENTYRE ANGOLA LDA', '5401149794', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-04', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('702', 'S.K.T.N COMERCIO E INDUSTRIA LDA', '5000411450', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-05', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('703', 'A. J. P', '002243977', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('704', 'ALTO BAIRO', '5000872636', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('705', 'SELFTEY', '5000982652', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('706', 'INOXIACOS', '5112161191', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('707', 'FORTUNATE DREAM CATCHER- COMERCIO GERAL ', '5000023787', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('708', 'BPC', '5410000552', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('709', ' LDV INPREDIMENTOS', '5171167745', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('710', 'SMS-ADPP-BENGUELA', '7403008855', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('711', 'ANGOALISSAR', '5410000269', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('712', 'MEIA ESQUADRIA', '5111046607', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('713', 'AFRICA VERDE LDA', '5000584371', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('714', 'diocese de cristo rei', '6722', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-17', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('715', 'polo de desenvolvimento industria de catumbela', '541704299', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('716', ' A PROCURA DOS CINCO SENTIDOS -FILIAL DE BENGUELA', '5417042994', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('717', 'DEL', '5402102082', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-21', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('718', 'MAFALDA SARRIL', '000000P01983', '', '', '', 'LUBITO', '', 'LUBITO', 'LUBITO', '2', 'LUBITO', 'BENGUELA', '', '2022-07-22', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('719', 'Fertiangola Trading', '5117001028', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('721', 'Arcam gold fish', '5000191841', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('722', 'AMUNDIAL  SEGUROS', '5401144440', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('723', 'FERRURE,  LDA', '5000881678', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('724', 'PERFECT   HOME   CONSTRUCAO  CIVIL   E   COMERCIO    LI', '5000183946', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('725', 'V. CHISSENDE', '5402138087', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('726', 'NINO E FILHOS LDA', '5112157798', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-28', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('727', 'JOZE', '000575611HO036', '', '', '', 'DR.ANTONIO AGUSTINHO NETO', '1', 'DR.ANTONIO AGUSTINHO NETO', 'DR.ANTONIO AGUSTINHO NETO', '2', 'BENGUELA', 'BENGUELA', '', '2022-07-28', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('728', 'ANO CARIO E LUU PRESTACAO DE CERVIÇOS', '5417484075', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('729', 'DA AVANES', '5419003520', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('730', 'AGT WACO CUNGO', '5000319520', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('731', 'SAKSON LDA', '5111048561', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-07-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('733', 'HABITAÇAO', '5000348007', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('734', 'S.A.T.   GENERAL,  LDA', '5000629308', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('736', 'VAO VAO', '5403075100', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('737', 'PORTO DO LOBITO', '5112142340', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('738', 'JACS', '001785892BA033', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-08-04', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('739', 'MEP', '5000339547', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('740', 'GAP TRANSPORTE HUILA', '11.19', '', '', '', '0', '', '0', '0', '2', 'Benguela', '', '', '2022-08-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('741', 'S C B ', '5111034900', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('742', 'MIGUEL', '266777', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-07', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('743', 'FARMACIA QUIM MONTEIRO', '5111052925', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('744', 'MANPOWER LDA', '5417051837', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('745', 'EBRARD RODRIGO DA COSTA', '2111044660', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('746', 'Socenter', '5401008775', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-18', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('747', 'GKO', '5402138303', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-19', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('749', 'YAN RENQIANG-COMERCIO DE SERVICOS LDA', '5000928615', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-23', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('750', 'SAPENO    SERVIÇO', '5000919411', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-25', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('751', 'VISAGE SERVICO LD', '5111054499', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-26', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('752', 'SLN FCCB SA', '5000053120', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-27', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('753', 'DDB HOLDING SERVICES LDA', '5417359718', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-30', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('754', 'TCHIANE LDA', '5417612480', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('755', 'EUROAUTO ANGOLA', '5000263176', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('756', 'GRUPO CONTENTE', '5111050450', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('757', 'DF KUKU, (SU) LDA', '5000224499', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-08-31', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('758', 'B.M.F', '5410003772', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-01', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('760', 'ACAIL ANGOLA (SA)', '5401142200', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('761', 'ESTRELA DA FLORESTA', '5484024684', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('762', 'C N E', '5000349216', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-02', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('763', 'IC2M', '500552089', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-03', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('764', 'MONTE  CARSERVICE ,  LDA', '5121018681', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('765', 'jackson  studio', '5000976741', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-09', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('766', 'SE FARMA', '5417261726', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('767', 'INDAGRO', '5171163332', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-11', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('768', 'SINSE', '5000304834', '', '', '', '0', '', '0', '0', '2', 'BENGUELA', 'BENGUELA', '', '2022-09-12', 'ANGOLA', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('769', 'ADCN', '500082910', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('770', 'ADCN', '5000082910', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('771', 'PADARIA   AZIZ  COMERCIO  E  SERVIÇO', '5000990450', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('772', 'BONGUE  YO  TCHIVILA', '5171169977', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-12', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('773', 'CRIS-M', '5000479586', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('774', 'SONDOS LDA', '5000075205', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-13', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('775', 'RF MEDICAL LDA', '5117000862', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-14', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('776', 'HAPEC', '2111132527', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('777', 'IRISSTRANS', '5417284416', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('778', 'RISEANG', '5000369241', '', '', '', '0', '', '0', '0', '2', 'Benguela', 'Benguela', '', '2022-09-15', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('1', 'Consumidor final', '999999999', '', '0', 'c', 'Benguela', '0', 'Benguela', 'Benguela', '2', 'Benguela', 'Benguela', '', '2021-12-01', 'Angola', '0');


#
# TABLE STRUCTURE FOR: tec_expenses
#

DROP TABLE IF EXISTS `tec_expenses`;

CREATE TABLE `tec_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference` varchar(50) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `created_by` varchar(55) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_expenses` (`id`, `date`, `reference`, `amount`, `note`, `created_by`, `attachment`) VALUES ('1', '2021-06-06 23:38:00', 'qaw', '100000.00', '', '16', NULL);


#
# TABLE STRUCTURE FOR: tec_gift_cards
#

DROP TABLE IF EXISTS `tec_gift_cards`;

CREATE TABLE `tec_gift_cards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `card_no` varchar(20) NOT NULL,
  `value` decimal(25,2) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `balance` decimal(25,2) NOT NULL,
  `expiry` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `card_no` (`card_no`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('5', '2018-03-21 07:00:22', '2489 7897 0990 8779', '250.40', NULL, '250.40', NULL, '5');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('6', '2019-08-12 17:00:48', '1111 1111 1111 1111', '50000.00', NULL, '49997.72', NULL, '7');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('7', '2019-10-22 17:50:53', '4242 4242 4242 4242', '1000.00', NULL, '1000.00', NULL, '14');


#
# TABLE STRUCTURE FOR: tec_groups
#

DROP TABLE IF EXISTS `tec_groups`;

CREATE TABLE `tec_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_groups` (`id`, `name`, `description`) VALUES ('1', 'admin', 'Administrator');
INSERT INTO `tec_groups` (`id`, `name`, `description`) VALUES ('2', 'staff', 'Staff');
INSERT INTO `tec_groups` (`id`, `name`, `description`) VALUES ('3', 'garson', 'Garson');
INSERT INTO `tec_groups` (`id`, `name`, `description`) VALUES ('4', 'super_admin', 'Super Admin');
INSERT INTO `tec_groups` (`id`, `name`, `description`) VALUES ('5', 'conta', 'Comercial');


#
# TABLE STRUCTURE FOR: tec_licences
#

DROP TABLE IF EXISTS `tec_licences`;

CREATE TABLE `tec_licences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `licence` varchar(250) NOT NULL,
  `expired_month` varchar(100) NOT NULL,
  `status` varchar(100) DEFAULT NULL,
  `insert_date` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('6', '7', '34b62b089b824d98abf8cb80d5582bb8edf2508d', 'MTI=', 'used', '2019-11-22');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('7', '14', 'f87349f623bb99c8aca6ad3bb8042bd320731c86', 'MQ==', NULL, NULL);
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('35', '25', 'fa8c3f2aef6020df64aa0411051d1cc83b252878', 'MTI=', 'used', '2021-05-30');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('34', '24', '3557d9f3b99560005365ebd3c3d57d4c498e19ab', 'MTI=', 'used', '2021-01-27');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('33', '23', '91064c7b451f13a4fa1b4539c5d0ab9600bfad66', 'MTI=', 'used', '2021-01-21');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('32', '21', 'fafad1289259a791073eace72a1552d18193cf03', 'MTI=', NULL, NULL);
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('31', '22', '0343501f70e1735063c91255dfa0856abf262681', 'MTI=', 'used', '2021-01-18');


#
# TABLE STRUCTURE FOR: tec_login_attempts
#

DROP TABLE IF EXISTS `tec_login_attempts`;

CREATE TABLE `tec_login_attempts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_mesas
#

DROP TABLE IF EXISTS `tec_mesas`;

CREATE TABLE `tec_mesas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `places` int(5) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('56', 'mesa1', '2', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('58', 'mesa3', '4', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('64', 'mesa5', '0', '1');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('65', 'mesa6', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('67', 'mesa8', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('68', 'mesa9', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('69', 'mesa10', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('70', 'mesa11', '0', '0');


#
# TABLE STRUCTURE FOR: tec_numbering
#

DROP TABLE IF EXISTS `tec_numbering`;

CREATE TABLE `tec_numbering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` int(20) NOT NULL,
  `InvoiceType` varchar(4) NOT NULL,
  `InvoiceYear` year(4) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=15383 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1', '1', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2', '1', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3', '2', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4', '2', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5', '3', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6', '3', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7', '4', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('8', '4', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('9', '5', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('10', '5', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('11', '6', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('12', '6', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('13', '7', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('14', '7', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('15', '8', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('16', '8', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('17', '9', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('18', '9', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('19', '10', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('20', '10', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('21', '11', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('22', '11', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('23', '12', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('24', '12', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('25', '13', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('26', '13', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('27', '14', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('28', '14', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('29', '15', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('30', '15', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('31', '16', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('32', '16', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('33', '17', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('34', '17', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('35', '18', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('36', '18', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('37', '19', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('38', '19', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('39', '20', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('40', '20', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('41', '21', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('42', '21', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('43', '22', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('44', '22', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('45', '23', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('46', '23', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('47', '24', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('48', '24', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('49', '25', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('50', '25', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('51', '26', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('52', '26', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('53', '27', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('54', '27', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('55', '28', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('56', '28', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('57', '29', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('58', '29', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('59', '30', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('60', '30', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('61', '31', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('62', '31', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('63', '32', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('64', '32', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('65', '33', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('66', '33', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('67', '34', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('68', '34', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('69', '35', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('70', '35', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('71', '36', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('72', '36', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('73', '37', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('74', '37', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('75', '38', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('76', '38', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('77', '39', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('78', '39', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('79', '40', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('80', '40', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('81', '41', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('82', '41', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('83', '42', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('84', '42', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('85', '43', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('86', '43', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('87', '44', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('88', '44', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('89', '45', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('90', '45', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('91', '46', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('92', '46', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('93', '47', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('94', '47', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('95', '48', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('96', '48', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('97', '49', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('98', '49', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('99', '50', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('100', '50', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('101', '51', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('102', '51', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('103', '52', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('104', '52', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('105', '53', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('106', '53', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('107', '54', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('108', '54', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('109', '55', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('110', '55', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('111', '56', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('112', '56', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('113', '57', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('114', '57', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('115', '58', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('116', '58', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('117', '59', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('118', '59', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('119', '60', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('120', '60', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('121', '1', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('122', '61', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('123', '61', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('124', '62', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('125', '62', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('126', '63', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('127', '63', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('128', '64', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('129', '64', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('130', '65', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('131', '65', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('132', '66', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('133', '66', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('134', '67', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('135', '67', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('136', '68', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('137', '68', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('138', '69', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('139', '69', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('140', '70', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('141', '70', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('142', '71', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('143', '71', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('144', '72', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('145', '72', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('146', '73', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('147', '73', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('148', '74', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('149', '74', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('150', '75', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('151', '75', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('152', '76', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('153', '76', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('154', '77', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('155', '77', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('156', '78', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('157', '78', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('158', '79', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('159', '79', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('160', '80', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('161', '80', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('162', '81', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('163', '81', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('164', '82', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('165', '82', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('166', '83', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('167', '83', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('168', '84', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('169', '84', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('170', '85', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('171', '85', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('172', '86', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('173', '86', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('174', '2', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('175', '3', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('176', '87', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('177', '87', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('178', '88', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('179', '88', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('180', '89', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('181', '89', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('182', '90', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('183', '90', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('184', '91', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('185', '91', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('186', '92', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('187', '92', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('188', '93', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('189', '93', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('190', '94', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('191', '94', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('192', '4', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('193', '95', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('194', '95', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('195', '96', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('196', '96', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('197', '97', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('198', '97', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('199', '98', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('200', '98', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('201', '99', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('202', '99', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('203', '100', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('204', '100', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('205', '101', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('206', '101', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('207', '5', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('208', '6', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('209', '7', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('210', '8', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('211', '9', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('212', '10', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('213', '11', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('214', '12', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('215', '13', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('216', '14', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('217', '15', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('218', '16', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('219', '102', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('220', '102', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('221', '103', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('222', '103', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('223', '104', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('224', '104', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('225', '105', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('226', '105', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('227', '106', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('228', '106', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('229', '107', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('230', '107', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('231', '108', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('232', '108', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('233', '109', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('234', '109', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('235', '110', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('236', '110', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('237', '17', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('238', '111', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('239', '111', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('240', '112', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('241', '112', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('242', '18', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('243', '113', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('244', '113', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('245', '114', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('246', '114', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('247', '115', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('248', '115', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('249', '19', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('250', '20', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('251', '116', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('252', '116', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('253', '21', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('254', '22', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('255', '23', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('256', '24', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('257', '25', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('258', '26', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('259', '27', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('260', '117', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('261', '117', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('262', '118', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('263', '118', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('264', '28', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('265', '119', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('266', '119', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('267', '120', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('268', '120', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('269', '121', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('270', '121', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('271', '122', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('272', '122', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('273', '123', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('274', '123', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('275', '124', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('276', '124', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('277', '125', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('278', '125', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('279', '126', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('280', '126', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('281', '127', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('282', '127', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('283', '128', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('284', '128', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('285', '129', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('286', '129', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('287', '130', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('288', '130', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('289', '131', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('290', '131', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('291', '132', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('292', '132', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('293', '133', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('294', '133', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('295', '134', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('296', '134', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('297', '135', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('298', '135', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('299', '136', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('300', '136', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('301', '137', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('302', '137', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('303', '138', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('304', '138', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('305', '139', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('306', '139', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('307', '140', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('308', '140', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('309', '141', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('310', '141', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('311', '142', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('312', '142', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('313', '143', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('314', '143', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('315', '144', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('316', '144', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('317', '145', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('318', '145', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('319', '146', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('320', '146', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('321', '147', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('322', '147', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('323', '148', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('324', '148', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('325', '149', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('326', '149', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('327', '150', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('328', '150', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('329', '151', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('330', '151', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('331', '152', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('332', '152', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('333', '153', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('334', '153', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('335', '154', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('336', '154', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('337', '155', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('338', '155', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('339', '156', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('340', '156', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('341', '157', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('342', '157', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('343', '158', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('344', '158', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('345', '159', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('346', '159', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('347', '160', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('348', '160', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('349', '161', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('350', '161', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('351', '162', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('352', '162', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('353', '163', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('354', '163', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('355', '164', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('356', '164', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('357', '165', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('358', '165', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('359', '166', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('360', '166', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('361', '167', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('362', '167', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('363', '168', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('364', '168', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('365', '169', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('366', '169', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('367', '170', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('368', '170', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('369', '171', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('370', '171', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('371', '172', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('372', '172', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('373', '173', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('374', '173', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('375', '174', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('376', '174', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('377', '175', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('378', '175', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('379', '176', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('380', '176', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('381', '1', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('382', '177', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('383', '177', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('384', '178', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('385', '178', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('386', '179', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('387', '179', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('388', '180', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('389', '180', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('390', '181', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('391', '181', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('392', '182', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('393', '182', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('394', '183', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('395', '183', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('396', '184', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('397', '184', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('398', '185', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('399', '185', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('400', '186', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('401', '186', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('402', '187', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('403', '187', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('404', '188', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('405', '188', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('406', '189', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('407', '189', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('408', '190', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('409', '190', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('410', '191', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('411', '191', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('412', '192', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('413', '192', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('414', '193', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('415', '193', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('416', '194', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('417', '194', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('418', '195', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('419', '195', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('420', '196', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('421', '196', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('422', '197', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('423', '197', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('424', '198', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('425', '198', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('426', '29', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('427', '30', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('428', '31', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('429', '32', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('430', '33', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('431', '34', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('432', '35', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('433', '36', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('434', '37', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('435', '199', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('436', '199', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('437', '200', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('438', '200', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('439', '201', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('440', '201', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('441', '202', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('442', '202', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('443', '203', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('444', '203', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('445', '204', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('446', '204', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('447', '205', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('448', '205', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('449', '206', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('450', '206', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('451', '207', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('452', '207', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('453', '208', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('454', '208', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('455', '209', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('456', '209', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('457', '210', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('458', '210', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('459', '211', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('460', '211', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('461', '212', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('462', '212', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('463', '38', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('464', '213', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('465', '213', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('466', '214', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('467', '214', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('468', '215', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('469', '215', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('470', '216', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('471', '216', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('472', '217', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('473', '217', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('474', '218', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('475', '218', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('476', '219', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('477', '219', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('478', '220', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('479', '220', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('480', '221', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('481', '221', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('482', '222', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('483', '222', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('484', '223', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('485', '223', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('486', '224', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('487', '224', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('488', '225', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('489', '225', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('490', '226', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('491', '226', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('492', '227', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('493', '227', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('494', '228', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('495', '228', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('496', '229', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('497', '229', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('498', '230', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('499', '230', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('500', '231', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('501', '231', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('502', '232', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('503', '232', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('504', '233', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('505', '233', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('506', '234', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('507', '234', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('508', '235', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('509', '235', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('510', '236', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('511', '236', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('512', '237', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('513', '237', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('514', '238', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('515', '238', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('516', '239', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('517', '239', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('518', '240', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('519', '240', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('520', '241', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('521', '241', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('522', '242', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('523', '242', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('524', '243', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('525', '243', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('526', '244', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('527', '244', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('528', '245', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('529', '245', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('530', '246', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('531', '246', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('532', '247', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('533', '247', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('534', '248', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('535', '248', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('536', '249', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('537', '249', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('538', '250', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('539', '250', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('540', '251', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('541', '251', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('542', '252', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('543', '252', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('544', '253', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('545', '253', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('546', '254', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('547', '254', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('548', '255', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('549', '255', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('550', '256', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('551', '256', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('552', '257', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('553', '257', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('554', '258', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('555', '258', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('556', '2', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('557', '259', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('558', '259', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('559', '260', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('560', '260', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('561', '261', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('562', '261', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('563', '262', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('564', '262', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('565', '263', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('566', '263', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('567', '264', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('568', '264', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('569', '265', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('570', '265', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('571', '266', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('572', '266', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('573', '267', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('574', '267', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('575', '268', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('576', '268', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('577', '269', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('578', '269', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('579', '270', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('580', '270', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('581', '271', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('582', '271', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('583', '272', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('584', '272', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('585', '273', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('586', '273', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('587', '274', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('588', '274', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('589', '275', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('590', '275', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('591', '276', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('592', '276', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('593', '277', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('594', '277', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('595', '278', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('596', '278', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('597', '279', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('598', '279', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('599', '280', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('600', '280', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('601', '281', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('602', '281', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('603', '282', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('604', '282', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('605', '283', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('606', '283', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('607', '284', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('608', '284', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('609', '285', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('610', '285', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('611', '286', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('612', '286', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('613', '287', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('614', '287', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('615', '288', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('616', '288', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('617', '289', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('618', '289', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('619', '290', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('620', '290', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('621', '291', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('622', '291', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('623', '292', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('624', '292', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('625', '293', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('626', '293', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('627', '294', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('628', '294', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('629', '295', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('630', '295', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('631', '296', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('632', '296', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('633', '297', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('634', '297', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('635', '298', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('636', '298', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('637', '299', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('638', '299', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('639', '300', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('640', '300', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('641', '301', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('642', '301', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('643', '302', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('644', '302', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('645', '303', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('646', '303', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('647', '304', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('648', '304', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('649', '305', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('650', '305', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('651', '306', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('652', '306', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('653', '3', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('654', '307', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('655', '307', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('656', '308', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('657', '308', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('658', '309', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('659', '309', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('660', '310', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('661', '310', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('662', '311', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('663', '311', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('664', '312', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('665', '312', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('666', '313', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('667', '313', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('668', '314', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('669', '314', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('670', '315', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('671', '315', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('672', '316', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('673', '316', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('674', '39', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('675', '317', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('676', '317', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('677', '318', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('678', '318', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('679', '319', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('680', '319', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('681', '320', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('682', '320', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('683', '321', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('684', '321', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('685', '322', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('686', '322', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('687', '323', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('688', '323', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('689', '324', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('690', '324', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('691', '325', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('692', '325', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('693', '326', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('694', '326', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('695', '327', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('696', '327', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('697', '328', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('698', '328', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('699', '329', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('700', '329', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('701', '330', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('702', '330', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('703', '331', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('704', '331', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('705', '332', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('706', '332', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('707', '333', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('708', '333', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('709', '334', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('710', '334', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('711', '335', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('712', '335', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('713', '336', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('714', '336', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('715', '337', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('716', '337', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('717', '338', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('718', '338', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('719', '339', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('720', '339', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('721', '340', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('722', '340', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('723', '341', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('724', '341', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('725', '342', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('726', '342', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('727', '343', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('728', '343', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('729', '344', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('730', '344', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('731', '345', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('732', '345', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('733', '346', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('734', '346', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('735', '347', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('736', '347', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('737', '348', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('738', '348', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('739', '349', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('740', '349', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('741', '350', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('742', '350', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('743', '351', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('744', '351', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('745', '352', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('746', '352', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('747', '353', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('748', '353', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('749', '354', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('750', '354', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('751', '355', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('752', '355', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('753', '356', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('754', '356', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('755', '357', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('756', '357', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('757', '358', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('758', '358', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('759', '359', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('760', '359', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('761', '360', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('762', '360', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('763', '361', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('764', '361', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('765', '362', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('766', '362', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('767', '363', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('768', '363', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('769', '364', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('770', '364', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('771', '365', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('772', '365', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('773', '366', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('774', '366', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('775', '367', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('776', '367', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('777', '368', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('778', '368', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('779', '369', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('780', '369', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('781', '370', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('782', '370', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('783', '371', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('784', '371', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('785', '372', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('786', '372', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('787', '373', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('788', '373', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('789', '374', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('790', '374', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('791', '375', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('792', '375', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('793', '376', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('794', '376', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('795', '377', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('796', '377', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('797', '378', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('798', '378', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('799', '379', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('800', '379', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('801', '380', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('802', '380', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('803', '381', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('804', '381', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('805', '382', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('806', '382', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('807', '383', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('808', '383', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('809', '384', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('810', '384', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('811', '385', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('812', '385', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('813', '386', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('814', '386', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('815', '387', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('816', '387', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('817', '388', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('818', '388', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('819', '389', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('820', '389', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('821', '390', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('822', '390', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('823', '391', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('824', '391', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('825', '392', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('826', '392', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('827', '393', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('828', '393', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('829', '394', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('830', '394', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('831', '395', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('832', '395', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('833', '396', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('834', '396', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('835', '397', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('836', '397', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('837', '398', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('838', '398', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('839', '399', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('840', '399', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('841', '400', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('842', '400', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('843', '401', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('844', '401', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('845', '402', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('846', '402', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('847', '403', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('848', '403', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('849', '404', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('850', '404', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('851', '405', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('852', '405', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('853', '406', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('854', '406', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('855', '407', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('856', '407', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('857', '408', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('858', '408', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('859', '409', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('860', '409', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('861', '410', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('862', '410', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('863', '411', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('864', '411', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('865', '412', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('866', '412', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('867', '413', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('868', '413', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('869', '414', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('870', '414', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('871', '415', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('872', '415', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('873', '40', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('874', '4', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('875', '416', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('876', '1', 'NC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('877', '417', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('878', '416', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('879', '418', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('880', '417', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('881', '419', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('882', '418', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('883', '420', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('884', '419', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('885', '421', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('886', '420', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('887', '422', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('888', '421', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('889', '423', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('890', '422', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('891', '424', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('892', '423', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('893', '425', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('894', '424', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('895', '426', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('896', '425', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('897', '427', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('898', '426', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('899', '428', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('900', '427', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('901', '429', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('902', '428', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('903', '430', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('904', '429', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('905', '431', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('906', '430', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('907', '432', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('908', '431', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('909', '433', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('910', '432', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('911', '434', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('912', '433', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('913', '435', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('914', '434', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('915', '436', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('916', '435', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('917', '437', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('918', '436', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('919', '438', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('920', '437', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('921', '439', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('922', '438', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('923', '440', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('924', '439', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('925', '441', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('926', '440', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('927', '442', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('928', '441', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('929', '443', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('930', '442', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('931', '444', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('932', '443', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('933', '445', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('934', '444', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('935', '446', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('936', '445', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('937', '447', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('938', '446', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('939', '448', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('940', '447', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('941', '449', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('942', '448', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('943', '450', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('944', '449', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('945', '5', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('946', '451', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('947', '450', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('948', '452', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('949', '451', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('950', '453', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('951', '452', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('952', '454', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('953', '453', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('954', '455', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('955', '454', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('956', '456', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('957', '455', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('958', '457', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('959', '456', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('960', '458', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('961', '457', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('962', '459', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('963', '458', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('964', '460', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('965', '459', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('966', '461', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('967', '460', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('968', '462', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('969', '461', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('970', '463', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('971', '462', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('972', '464', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('973', '463', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('974', '465', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('975', '464', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('976', '466', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('977', '465', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('978', '467', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('979', '466', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('980', '468', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('981', '467', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('982', '469', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('983', '468', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('984', '470', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('985', '469', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('986', '471', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('987', '470', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('988', '472', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('989', '471', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('990', '473', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('991', '472', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('992', '474', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('993', '473', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('994', '475', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('995', '474', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('996', '476', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('997', '475', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('998', '477', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('999', '476', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1000', '478', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1001', '477', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1002', '479', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1003', '478', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1004', '480', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1005', '479', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1006', '481', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1007', '480', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1008', '482', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1009', '481', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1010', '483', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1011', '482', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1012', '484', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1013', '483', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1014', '485', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1015', '484', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1016', '486', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1017', '485', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1018', '487', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1019', '486', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1020', '488', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1021', '487', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1022', '489', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1023', '488', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1024', '490', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1025', '489', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1026', '491', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1027', '490', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1028', '492', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1029', '491', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1030', '493', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1031', '492', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1032', '494', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1033', '493', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1034', '495', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1035', '494', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1036', '496', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1037', '495', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1038', '497', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1039', '496', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1040', '498', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1041', '497', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1042', '499', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1043', '498', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1044', '500', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1045', '499', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1046', '501', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1047', '500', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1048', '502', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1049', '501', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1050', '503', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1051', '502', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1052', '504', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1053', '503', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1054', '505', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1055', '504', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1056', '506', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1057', '505', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1058', '507', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1059', '506', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1060', '508', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1061', '507', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1062', '509', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1063', '508', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1064', '510', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1065', '509', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1066', '511', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1067', '510', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1068', '512', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1069', '511', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1070', '513', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1071', '512', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1072', '514', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1073', '513', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1074', '515', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1075', '514', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1076', '516', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1077', '515', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1078', '517', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1079', '516', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1080', '518', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1081', '517', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1082', '519', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1083', '518', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1084', '520', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1085', '519', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1086', '521', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1087', '520', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1088', '522', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1089', '521', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1090', '523', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1091', '522', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1092', '524', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1093', '523', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1094', '525', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1095', '524', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1096', '526', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1097', '525', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1098', '527', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1099', '526', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1100', '528', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1101', '527', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1102', '529', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1103', '528', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1104', '530', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1105', '529', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1106', '531', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1107', '530', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1108', '532', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1109', '531', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1110', '533', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1111', '532', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1112', '534', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1113', '533', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1114', '535', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1115', '534', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1116', '536', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1117', '535', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1118', '537', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1119', '536', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1120', '538', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1121', '537', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1122', '539', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1123', '538', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1124', '540', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1125', '539', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1126', '541', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1127', '540', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1128', '542', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1129', '541', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1130', '543', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1131', '542', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1132', '544', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1133', '543', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1134', '545', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1135', '544', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1136', '546', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1137', '545', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1138', '547', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1139', '546', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1140', '548', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1141', '547', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1142', '549', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1143', '548', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1144', '550', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1145', '549', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1146', '551', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1147', '550', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1148', '552', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1149', '551', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1150', '553', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1151', '552', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1152', '554', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1153', '553', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1154', '555', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1155', '554', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1156', '556', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1157', '555', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1158', '557', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1159', '556', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1160', '558', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1161', '557', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1162', '559', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1163', '558', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1164', '560', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1165', '559', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1166', '561', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1167', '560', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1168', '562', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1169', '561', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1170', '563', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1171', '562', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1172', '564', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1173', '563', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1174', '565', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1175', '564', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1176', '566', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1177', '565', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1178', '567', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1179', '566', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1180', '568', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1181', '567', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1182', '569', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1183', '568', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1184', '570', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1185', '569', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1186', '571', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1187', '570', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1188', '572', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1189', '571', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1190', '573', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1191', '572', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1192', '574', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1193', '573', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1194', '575', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1195', '574', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1196', '576', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1197', '575', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1198', '577', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1199', '576', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1200', '578', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1201', '577', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1202', '579', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1203', '578', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1204', '580', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1205', '579', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1206', '581', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1207', '580', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1208', '582', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1209', '581', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1210', '583', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1211', '582', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1212', '584', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1213', '583', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1214', '585', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1215', '584', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1216', '586', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1217', '585', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1218', '587', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1219', '586', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1220', '588', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1221', '587', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1222', '589', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1223', '588', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1224', '590', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1225', '589', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1226', '591', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1227', '590', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1228', '592', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1229', '591', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1230', '593', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1231', '592', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1232', '594', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1233', '593', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1234', '595', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1235', '594', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1236', '596', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1237', '595', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1238', '597', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1239', '596', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1240', '598', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1241', '597', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1242', '599', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1243', '598', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1244', '600', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1245', '599', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1246', '601', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1247', '600', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1248', '602', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1249', '601', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1250', '603', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1251', '602', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1252', '604', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1253', '603', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1254', '605', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1255', '604', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1256', '606', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1257', '605', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1258', '607', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1259', '606', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1260', '608', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1261', '607', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1262', '609', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1263', '608', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1264', '610', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1265', '609', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1266', '611', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1267', '610', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1268', '612', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1269', '611', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1270', '613', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1271', '612', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1272', '614', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1273', '613', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1274', '615', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1275', '614', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1276', '616', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1277', '615', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1278', '617', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1279', '616', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1280', '618', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1281', '617', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1282', '619', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1283', '618', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1284', '620', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1285', '619', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1286', '621', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1287', '620', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1288', '622', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1289', '621', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1290', '623', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1291', '622', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1292', '624', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1293', '623', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1294', '625', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1295', '624', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1296', '626', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1297', '625', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1298', '627', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1299', '626', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1300', '628', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1301', '627', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1302', '629', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1303', '628', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1304', '630', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1305', '629', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1306', '631', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1307', '630', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1308', '632', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1309', '631', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1310', '633', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1311', '632', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1312', '634', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1313', '633', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1314', '635', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1315', '634', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1316', '636', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1317', '635', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1318', '637', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1319', '636', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1320', '638', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1321', '637', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1322', '639', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1323', '638', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1324', '640', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1325', '639', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1326', '641', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1327', '640', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1328', '642', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1329', '641', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1330', '41', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1331', '643', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1332', '642', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1333', '644', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1334', '643', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1335', '645', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1336', '644', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1337', '646', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1338', '645', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1339', '647', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1340', '646', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1341', '648', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1342', '647', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1343', '649', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1344', '648', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1345', '650', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1346', '649', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1347', '651', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1348', '650', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1349', '652', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1350', '651', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1351', '653', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1352', '652', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1353', '654', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1354', '653', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1355', '655', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1356', '654', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1357', '656', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1358', '655', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1359', '657', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1360', '656', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1361', '658', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1362', '657', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1363', '659', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1364', '658', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1365', '660', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1366', '659', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1367', '661', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1368', '660', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1369', '662', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1370', '661', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1371', '663', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1372', '662', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1373', '664', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1374', '663', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1375', '665', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1376', '664', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1377', '666', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1378', '665', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1379', '667', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1380', '666', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1381', '668', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1382', '667', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1383', '669', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1384', '668', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1385', '670', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1386', '669', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1387', '671', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1388', '670', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1389', '672', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1390', '671', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1391', '673', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1392', '672', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1393', '674', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1394', '673', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1395', '675', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1396', '674', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1397', '676', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1398', '675', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1399', '677', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1400', '676', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1401', '678', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1402', '677', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1403', '679', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1404', '678', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1405', '680', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1406', '679', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1407', '681', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1408', '680', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1409', '682', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1410', '681', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1411', '683', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1412', '682', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1413', '684', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1414', '683', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1415', '685', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1416', '684', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1417', '686', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1418', '685', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1419', '687', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1420', '686', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1421', '688', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1422', '687', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1423', '689', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1424', '688', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1425', '690', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1426', '689', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1427', '691', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1428', '690', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1429', '692', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1430', '691', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1431', '693', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1432', '692', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1433', '694', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1434', '693', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1435', '695', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1436', '694', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1437', '696', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1438', '695', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1439', '697', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1440', '696', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1441', '698', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1442', '697', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1443', '699', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1444', '698', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1445', '700', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1446', '699', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1447', '701', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1448', '700', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1449', '702', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1450', '701', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1451', '703', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1452', '702', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1453', '704', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1454', '703', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1455', '705', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1456', '704', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1457', '706', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1458', '705', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1459', '707', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1460', '706', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1461', '708', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1462', '707', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1463', '6', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1464', '709', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1465', '708', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1466', '710', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1467', '709', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1468', '711', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1469', '710', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1470', '712', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1471', '711', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1472', '713', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1473', '712', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1474', '714', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1475', '713', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1476', '42', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1477', '715', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1478', '714', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1479', '716', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1480', '715', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1481', '717', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1482', '716', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1483', '718', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1484', '717', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1485', '719', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1486', '718', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1487', '720', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1488', '719', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1489', '721', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1490', '720', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1491', '722', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1492', '721', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1493', '723', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1494', '722', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1495', '724', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1496', '723', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1497', '725', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1498', '724', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1499', '43', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1500', '726', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1501', '725', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1502', '727', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1503', '726', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1504', '728', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1505', '727', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1506', '729', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1507', '728', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1508', '730', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1509', '729', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1510', '731', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1511', '730', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1512', '732', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1513', '731', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1514', '733', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1515', '732', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1516', '734', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1517', '733', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1518', '735', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1519', '734', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1520', '736', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1521', '735', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1522', '737', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1523', '736', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1524', '738', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1525', '737', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1526', '739', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1527', '738', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1528', '740', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1529', '739', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1530', '741', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1531', '740', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1532', '742', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1533', '741', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1534', '743', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1535', '742', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1536', '744', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1537', '743', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1538', '745', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1539', '744', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1540', '746', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1541', '745', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1542', '747', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1543', '746', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1544', '748', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1545', '747', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1546', '749', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1547', '748', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1548', '750', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1549', '749', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1550', '751', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1551', '750', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1552', '752', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1553', '751', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1554', '753', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1555', '752', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1556', '754', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1557', '753', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1558', '755', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1559', '754', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1560', '756', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1561', '755', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1562', '757', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1563', '756', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1564', '758', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1565', '757', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1566', '759', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1567', '758', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1568', '760', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1569', '759', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1570', '761', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1571', '760', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1572', '762', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1573', '761', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1574', '763', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1575', '762', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1576', '764', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1577', '763', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1578', '44', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1579', '765', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1580', '764', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1581', '766', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1582', '765', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1583', '767', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1584', '766', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1585', '768', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1586', '767', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1587', '769', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1588', '768', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1589', '770', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1590', '769', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1591', '771', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1592', '770', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1593', '772', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1594', '771', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1595', '773', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1596', '772', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1597', '774', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1598', '773', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1599', '775', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1600', '774', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1601', '776', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1602', '775', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1603', '777', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1604', '776', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1605', '778', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1606', '777', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1607', '779', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1608', '778', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1609', '780', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1610', '779', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1611', '781', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1612', '780', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1613', '782', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1614', '781', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1615', '783', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1616', '782', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1617', '784', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1618', '783', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1619', '785', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1620', '784', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1621', '786', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1622', '785', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1623', '787', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1624', '786', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1625', '788', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1626', '787', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1627', '789', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1628', '788', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1629', '790', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1630', '789', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1631', '791', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1632', '790', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1633', '45', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1634', '792', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1635', '791', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1636', '793', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1637', '792', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1638', '794', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1639', '793', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1640', '795', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1641', '794', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1642', '796', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1643', '795', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1644', '797', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1645', '796', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1646', '798', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1647', '797', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1648', '799', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1649', '798', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1650', '7', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1651', '800', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1652', '799', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1653', '801', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1654', '800', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1655', '802', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1656', '801', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1657', '803', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1658', '802', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1659', '804', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1660', '803', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1661', '805', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1662', '804', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1663', '806', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1664', '805', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1665', '807', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1666', '806', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1667', '808', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1668', '807', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1669', '809', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1670', '808', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1671', '810', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1672', '809', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1673', '811', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1674', '810', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1675', '812', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1676', '811', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1677', '813', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1678', '812', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1679', '814', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1680', '813', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1681', '815', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1682', '814', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1683', '816', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1684', '815', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1685', '817', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1686', '816', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1687', '818', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1688', '817', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1689', '819', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1690', '818', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1691', '820', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1692', '819', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1693', '821', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1694', '820', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1695', '822', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1696', '821', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1697', '823', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1698', '822', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1699', '824', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1700', '823', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1701', '825', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1702', '824', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1703', '826', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1704', '825', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1705', '827', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1706', '826', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1707', '828', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1708', '827', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1709', '829', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1710', '828', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1711', '830', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1712', '829', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1713', '831', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1714', '830', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1715', '832', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1716', '831', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1717', '833', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1718', '832', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1719', '834', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1720', '833', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1721', '835', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1722', '834', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1723', '836', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1724', '835', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1725', '837', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1726', '836', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1727', '838', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1728', '837', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1729', '839', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1730', '838', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1731', '840', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1732', '839', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1733', '841', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1734', '840', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1735', '842', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1736', '841', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1737', '46', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1738', '8', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1739', '843', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1740', '842', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1741', '844', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1742', '843', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1743', '845', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1744', '844', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1745', '846', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1746', '845', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1747', '847', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1748', '846', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1749', '848', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1750', '847', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1751', '849', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1752', '848', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1753', '850', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1754', '849', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1755', '851', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1756', '850', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1757', '852', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1758', '851', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1759', '853', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1760', '852', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1761', '854', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1762', '853', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1763', '855', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1764', '854', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1765', '856', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1766', '855', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1767', '857', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1768', '856', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1769', '858', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1770', '857', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1771', '859', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1772', '858', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1773', '860', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1774', '859', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1775', '861', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1776', '860', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1777', '862', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1778', '861', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1779', '863', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1780', '862', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1781', '864', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1782', '863', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1783', '865', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1784', '864', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1785', '866', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1786', '865', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1787', '867', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1788', '866', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1789', '868', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1790', '867', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1791', '869', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1792', '868', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1793', '870', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1794', '869', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1795', '871', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1796', '870', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1797', '872', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1798', '871', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1799', '873', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1800', '872', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1801', '874', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1802', '873', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1803', '875', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1804', '874', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1805', '876', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1806', '875', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1807', '877', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1808', '876', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1809', '878', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1810', '877', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1811', '879', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1812', '878', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1813', '880', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1814', '879', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1815', '881', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1816', '880', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1817', '882', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1818', '881', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1819', '883', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1820', '882', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1821', '884', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1822', '883', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1823', '885', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1824', '884', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1825', '886', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1826', '885', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1827', '887', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1828', '886', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1829', '888', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1830', '887', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1831', '889', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1832', '888', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1833', '890', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1834', '889', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1835', '891', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1836', '890', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1837', '892', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1838', '891', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1839', '893', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1840', '892', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1841', '894', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1842', '893', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1843', '895', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1844', '894', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1845', '896', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1846', '895', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1847', '897', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1848', '896', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1849', '898', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1850', '897', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1851', '899', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1852', '898', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1853', '900', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1854', '899', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1855', '901', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1856', '900', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1857', '902', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1858', '901', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1859', '903', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1860', '902', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1861', '904', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1862', '903', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1863', '905', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1864', '904', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1865', '906', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1866', '905', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1867', '907', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1868', '906', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1869', '908', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1870', '907', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1871', '909', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1872', '908', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1873', '910', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1874', '909', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1875', '911', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1876', '910', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1877', '912', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1878', '911', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1879', '913', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1880', '912', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1881', '914', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1882', '913', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1883', '915', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1884', '914', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1885', '916', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1886', '915', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1887', '917', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1888', '916', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1889', '918', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1890', '917', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1891', '919', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1892', '918', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1893', '920', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1894', '919', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1895', '921', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1896', '920', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1897', '922', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1898', '921', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1899', '923', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1900', '922', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1901', '924', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1902', '923', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1903', '925', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1904', '924', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1905', '926', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1906', '925', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1907', '927', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1908', '926', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1909', '928', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1910', '927', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1911', '929', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1912', '928', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1913', '930', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1914', '929', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1915', '931', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1916', '930', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1917', '932', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1918', '931', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1919', '933', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1920', '932', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1921', '934', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1922', '933', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1923', '935', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1924', '934', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1925', '936', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1926', '935', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1927', '937', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1928', '936', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1929', '938', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1930', '937', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1931', '939', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1932', '938', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1933', '940', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1934', '939', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1935', '941', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1936', '940', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1937', '942', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1938', '941', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1939', '9', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1940', '943', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1941', '942', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1942', '944', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1943', '943', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1944', '945', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1945', '944', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1946', '946', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1947', '945', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1948', '947', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1949', '946', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1950', '948', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1951', '947', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1952', '949', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1953', '948', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1954', '950', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1955', '949', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1956', '951', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1957', '950', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1958', '952', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1959', '951', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1960', '953', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1961', '952', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1962', '954', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1963', '953', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1964', '955', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1965', '954', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1966', '956', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1967', '955', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1968', '957', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1969', '956', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1970', '958', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1971', '957', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1972', '959', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1973', '958', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1974', '960', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1975', '959', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1976', '961', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1977', '960', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1978', '962', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1979', '961', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1980', '963', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1981', '962', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1982', '964', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1983', '963', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1984', '965', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1985', '964', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1986', '966', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1987', '965', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1988', '967', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1989', '966', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1990', '968', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1991', '967', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1992', '969', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1993', '968', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1994', '970', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1995', '969', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1996', '971', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1997', '970', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1998', '972', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('1999', '971', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2000', '973', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2001', '972', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2002', '974', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2003', '973', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2004', '975', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2005', '974', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2006', '976', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2007', '975', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2008', '977', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2009', '976', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2010', '978', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2011', '977', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2012', '979', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2013', '978', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2014', '980', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2015', '979', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2016', '981', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2017', '980', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2018', '982', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2019', '981', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2020', '983', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2021', '982', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2022', '984', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2023', '983', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2024', '985', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2025', '984', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2026', '986', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2027', '985', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2028', '987', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2029', '986', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2030', '988', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2031', '987', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2032', '989', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2033', '988', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2034', '990', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2035', '989', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2036', '991', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2037', '990', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2038', '992', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2039', '991', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2040', '993', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2041', '992', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2042', '994', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2043', '993', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2044', '995', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2045', '994', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2046', '996', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2047', '995', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2048', '997', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2049', '996', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2050', '998', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2051', '997', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2052', '999', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2053', '998', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2054', '1000', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2055', '999', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2056', '1001', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2057', '1000', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2058', '1002', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2059', '1001', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2060', '1003', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2061', '1002', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2062', '1004', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2063', '1003', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2064', '1005', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2065', '1004', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2066', '1006', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2067', '1005', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2068', '1007', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2069', '1006', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2070', '1008', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2071', '1007', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2072', '1009', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2073', '1008', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2074', '1010', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2075', '1009', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2076', '1011', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2077', '1010', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2078', '1012', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2079', '1011', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2080', '1013', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2081', '1012', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2082', '1014', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2083', '1013', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2084', '1015', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2085', '1014', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2086', '1016', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2087', '1015', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2088', '1017', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2089', '1016', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2090', '1018', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2091', '1017', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2092', '1019', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2093', '1018', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2094', '1020', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2095', '1019', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2096', '1021', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2097', '1020', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2098', '1022', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2099', '1021', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2100', '1023', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2101', '1022', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2102', '1024', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2103', '1023', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2104', '1025', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2105', '1024', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2106', '1026', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2107', '1025', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2108', '1027', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2109', '1026', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2110', '1028', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2111', '1027', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2112', '1029', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2113', '1028', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2114', '1030', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2115', '1029', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2116', '1031', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2117', '1030', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2118', '1032', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2119', '1031', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2120', '1033', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2121', '1032', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2122', '1034', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2123', '1033', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2124', '1035', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2125', '1034', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2126', '1036', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2127', '1035', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2128', '1037', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2129', '1036', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2130', '1038', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2131', '1037', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2132', '1039', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2133', '1038', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2134', '1040', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2135', '1039', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2136', '1041', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2137', '1040', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2138', '1042', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2139', '1041', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2140', '1043', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2141', '1042', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2142', '1044', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2143', '1043', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2144', '1045', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2145', '1044', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2146', '1046', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2147', '1045', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2148', '1047', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2149', '1046', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2150', '1048', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2151', '1047', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2152', '1049', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2153', '1048', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2154', '1050', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2155', '1049', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2156', '1051', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2157', '1050', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2158', '1052', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2159', '1051', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2160', '1053', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2161', '1052', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2162', '1054', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2163', '1053', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2164', '1055', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2165', '1054', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2166', '1056', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2167', '1055', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2168', '1057', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2169', '1056', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2170', '10', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2171', '1058', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2172', '1057', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2173', '1059', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2174', '1058', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2175', '1060', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2176', '1059', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2177', '1061', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2178', '1060', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2179', '1062', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2180', '1061', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2181', '1063', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2182', '1062', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2183', '1064', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2184', '1063', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2185', '11', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2186', '1065', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2187', '1064', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2188', '1066', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2189', '1065', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2190', '12', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2191', '1067', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2192', '1066', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2193', '1068', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2194', '1067', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2195', '1069', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2196', '1068', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2197', '1070', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2198', '1069', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2199', '1071', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2200', '1070', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2201', '1072', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2202', '1071', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2203', '1073', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2204', '1072', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2205', '1074', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2206', '1073', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2207', '1075', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2208', '1074', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2209', '1076', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2210', '1075', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2211', '1077', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2212', '1076', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2213', '1078', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2214', '1077', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2215', '1079', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2216', '1078', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2217', '1080', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2218', '1079', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2219', '1081', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2220', '1080', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2221', '1082', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2222', '1081', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2223', '1083', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2224', '1082', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2225', '1084', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2226', '1083', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2227', '1085', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2228', '1084', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2229', '1086', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2230', '1085', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2231', '1087', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2232', '1086', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2233', '1088', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2234', '1087', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2235', '1089', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2236', '1088', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2237', '1090', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2238', '1089', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2239', '1091', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2240', '1090', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2241', '1092', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2242', '1091', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2243', '1093', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2244', '1092', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2245', '1094', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2246', '1093', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2247', '1095', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2248', '1094', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2249', '1096', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2250', '1095', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2251', '1097', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2252', '1096', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2253', '1098', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2254', '1097', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2255', '1099', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2256', '1098', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2257', '47', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2258', '1100', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2259', '1099', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2260', '1101', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2261', '1100', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2262', '1102', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2263', '1101', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2264', '1103', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2265', '1102', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2266', '1104', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2267', '1103', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2268', '1105', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2269', '1104', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2270', '1106', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2271', '1105', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2272', '1107', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2273', '1106', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2274', '1108', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2275', '1107', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2276', '1109', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2277', '1108', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2278', '1110', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2279', '1109', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2280', '1111', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2281', '1110', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2282', '1112', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2283', '1111', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2284', '1113', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2285', '1112', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2286', '1114', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2287', '1113', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2288', '1115', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2289', '1114', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2290', '48', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2291', '1116', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2292', '1115', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2293', '1117', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2294', '1116', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2295', '1118', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2296', '1117', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2297', '1119', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2298', '1118', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2299', '1120', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2300', '1119', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2301', '1121', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2302', '1120', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2303', '1122', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2304', '1121', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2305', '1123', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2306', '1122', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2307', '1124', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2308', '1123', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2309', '1125', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2310', '1124', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2311', '1126', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2312', '1125', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2313', '49', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2314', '1127', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2315', '1126', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2316', '1128', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2317', '1127', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2318', '50', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2319', '1129', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2320', '1128', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2321', '1130', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2322', '1129', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2323', '1131', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2324', '1130', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2325', '1132', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2326', '1131', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2327', '1133', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2328', '1132', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2329', '1134', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2330', '1133', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2331', '1135', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2332', '1134', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2333', '1136', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2334', '1135', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2335', '1137', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2336', '1136', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2337', '13', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2338', '1138', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2339', '1137', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2340', '1139', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2341', '1138', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2342', '1140', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2343', '1139', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2344', '1141', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2345', '1140', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2346', '1142', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2347', '1141', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2348', '1143', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2349', '1142', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2350', '1144', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2351', '1143', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2352', '51', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2353', '1145', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2354', '1144', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2355', '1146', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2356', '1145', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2357', '52', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2358', '1147', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2359', '1146', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2360', '1148', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2361', '1147', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2362', '1149', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2363', '1148', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2364', '1150', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2365', '1149', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2366', '1151', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2367', '1150', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2368', '1152', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2369', '1151', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2370', '1153', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2371', '1152', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2372', '1154', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2373', '1153', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2374', '1155', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2375', '1154', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2376', '1156', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2377', '1155', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2378', '1157', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2379', '1156', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2380', '1158', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2381', '1157', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2382', '1159', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2383', '1158', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2384', '1160', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2385', '1159', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2386', '1161', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2387', '1160', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2388', '1162', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2389', '1161', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2390', '1163', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2391', '1162', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2392', '1164', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2393', '1163', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2394', '1165', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2395', '1164', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2396', '1166', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2397', '1165', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2398', '1167', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2399', '1166', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2400', '1168', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2401', '1167', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2402', '1169', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2403', '1168', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2404', '1170', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2405', '1169', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2406', '1171', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2407', '1170', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2408', '1172', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2409', '1171', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2410', '1173', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2411', '1172', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2412', '1174', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2413', '1173', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2414', '1175', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2415', '1174', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2416', '1176', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2417', '1175', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2418', '1177', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2419', '1176', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2420', '1178', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2421', '1177', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2422', '1179', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2423', '1178', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2424', '1180', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2425', '1179', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2426', '1181', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2427', '1180', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2428', '1182', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2429', '1181', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2430', '1183', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2431', '1182', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2432', '1184', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2433', '1183', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2434', '1185', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2435', '1184', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2436', '1186', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2437', '1185', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2438', '1187', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2439', '1186', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2440', '1188', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2441', '1187', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2442', '1189', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2443', '1188', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2444', '1190', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2445', '1189', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2446', '1191', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2447', '1190', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2448', '1192', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2449', '1191', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2450', '1192', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2451', '1193', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2452', '1193', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2453', '1194', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2454', '1194', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2455', '1195', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2456', '1195', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2457', '1196', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2458', '1196', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2459', '1197', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2460', '1197', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2461', '1198', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2462', '1198', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2463', '1199', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2464', '1199', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2465', '1200', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2466', '1200', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2467', '1201', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2468', '1201', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2469', '1202', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2470', '1202', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2471', '1203', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2472', '1203', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2473', '1204', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2474', '1204', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2475', '1205', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2476', '1205', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2477', '1206', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2478', '1206', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2479', '1207', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2480', '1207', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2481', '1208', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2482', '1208', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2483', '1209', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2484', '1209', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2485', '1210', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2486', '1210', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2487', '1211', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2488', '1211', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2489', '1212', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2490', '1212', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2491', '1213', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2492', '1213', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2493', '1214', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2494', '1214', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2495', '1215', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2496', '1215', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2497', '1216', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2498', '1216', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2499', '1217', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2500', '1217', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2501', '1218', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2502', '1218', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2503', '1219', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2504', '1219', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2505', '1220', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2506', '1220', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2507', '1221', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2508', '1221', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2509', '1222', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2510', '1222', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2511', '1223', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2512', '1223', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2513', '1224', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2514', '1224', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2515', '1225', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2516', '1225', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2517', '1226', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2518', '1226', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2519', '1227', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2520', '1227', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2521', '1228', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2522', '1228', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2523', '1229', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2524', '1229', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2525', '1230', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2526', '1230', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2527', '1231', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2528', '1231', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2529', '1232', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2530', '1232', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2531', '1233', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2532', '1233', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2533', '1234', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2534', '1234', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2535', '1235', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2536', '1235', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2537', '1236', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2538', '1236', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2539', '1237', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2540', '1237', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2541', '1238', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2542', '1238', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2543', '1239', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2544', '1239', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2545', '1240', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2546', '1240', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2547', '1241', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2548', '1241', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2549', '1242', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2550', '1242', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2551', '1243', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2552', '1243', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2553', '1244', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2554', '1244', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2555', '1245', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2556', '1245', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2557', '1246', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2558', '1246', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2559', '1247', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2560', '1247', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2561', '1248', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2562', '1248', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2563', '1249', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2564', '1249', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2565', '1250', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2566', '1250', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2567', '1251', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2568', '1251', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2569', '1252', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2570', '1252', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2571', '1253', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2572', '1253', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2573', '1254', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2574', '1254', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2575', '1255', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2576', '1255', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2577', '1256', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2578', '1256', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2579', '1257', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2580', '1257', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2581', '1258', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2582', '1258', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2583', '1259', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2584', '1259', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2585', '1260', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2586', '1260', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2587', '1261', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2588', '1261', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2589', '1262', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2590', '1262', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2591', '1263', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2592', '1263', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2593', '1264', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2594', '1264', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2595', '1265', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2596', '1265', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2597', '1266', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2598', '1266', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2599', '1267', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2600', '1267', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2601', '1268', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2602', '1268', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2603', '1269', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2604', '1269', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2605', '1270', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2606', '1270', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2607', '1271', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2608', '1271', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2609', '1272', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2610', '1272', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2611', '1273', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2612', '1273', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2613', '1274', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2614', '1274', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2615', '53', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2616', '1275', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2617', '1275', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2618', '1276', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2619', '1276', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2620', '1277', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2621', '1277', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2622', '1278', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2623', '1278', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2624', '1279', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2625', '1279', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2626', '1280', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2627', '1280', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2628', '1281', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2629', '1281', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2630', '1282', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2631', '1282', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2632', '1283', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2633', '1283', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2634', '1284', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2635', '1284', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2636', '1285', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2637', '1285', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2638', '1286', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2639', '1286', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2640', '1287', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2641', '1287', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2642', '1288', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2643', '1288', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2644', '1289', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2645', '1289', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2646', '1290', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2647', '1290', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2648', '1291', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2649', '1291', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2650', '1292', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2651', '1292', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2652', '1293', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2653', '1293', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2654', '1294', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2655', '1294', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2656', '1295', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2657', '1295', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2658', '1296', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2659', '1296', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2660', '1297', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2661', '1297', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2662', '1298', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2663', '1298', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2664', '1299', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2665', '1299', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2666', '1300', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2667', '1300', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2668', '1301', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2669', '1301', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2670', '1302', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2671', '1302', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2672', '1303', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2673', '1303', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2674', '1304', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2675', '1304', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2676', '1305', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2677', '1305', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2678', '1306', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2679', '1306', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2680', '1307', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2681', '1307', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2682', '1308', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2683', '1308', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2684', '1309', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2685', '1309', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2686', '1310', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2687', '1310', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2688', '1311', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2689', '1311', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2690', '1312', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2691', '1312', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2692', '1313', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2693', '1313', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2694', '1314', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2695', '1314', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2696', '1315', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2697', '1315', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2698', '1316', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2699', '1316', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2700', '1317', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2701', '1317', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2702', '1318', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2703', '1318', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2704', '1319', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2705', '1319', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2706', '1320', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2707', '1320', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2708', '1321', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2709', '1321', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2710', '1322', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2711', '1322', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2712', '1323', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2713', '1323', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2714', '1324', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2715', '1324', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2716', '1325', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2717', '1325', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2718', '1326', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2719', '1326', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2720', '14', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2721', '1327', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2722', '1327', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2723', '1328', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2724', '1328', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2725', '1329', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2726', '1329', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2727', '1330', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2728', '1330', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2729', '1331', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2730', '1331', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2731', '1332', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2732', '1332', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2733', '1333', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2734', '1333', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2735', '1334', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2736', '1334', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2737', '1335', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2738', '1335', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2739', '1336', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2740', '1336', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2741', '1337', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2742', '1337', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2743', '1338', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2744', '1338', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2745', '1339', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2746', '1339', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2747', '1340', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2748', '1340', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2749', '1341', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2750', '1341', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2751', '1342', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2752', '1342', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2753', '1343', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2754', '1343', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2755', '1344', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2756', '1344', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2757', '1345', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2758', '1345', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2759', '1346', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2760', '1346', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2761', '1347', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2762', '1347', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2763', '1348', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2764', '1348', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2765', '1349', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2766', '1349', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2767', '1350', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2768', '1350', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2769', '54', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2770', '1351', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2771', '1351', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2772', '1352', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2773', '1352', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2774', '1353', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2775', '1353', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2776', '1354', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2777', '1354', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2778', '1355', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2779', '1355', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2780', '1356', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2781', '1356', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2782', '1357', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2783', '1357', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2784', '1358', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2785', '1358', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2786', '1359', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2787', '1359', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2788', '1360', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2789', '1360', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2790', '1361', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2791', '1361', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2792', '1362', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2793', '1362', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2794', '1363', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2795', '1363', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2796', '1364', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2797', '1364', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2798', '1365', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2799', '1365', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2800', '1366', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2801', '1366', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2802', '1367', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2803', '1367', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2804', '1368', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2805', '1368', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2806', '1369', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2807', '1369', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2808', '1370', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2809', '1370', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2810', '1371', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2811', '1371', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2812', '1372', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2813', '1372', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2814', '1373', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2815', '1373', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2816', '1374', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2817', '1374', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2818', '1375', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2819', '1375', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2820', '1376', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2821', '1376', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2822', '1377', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2823', '1377', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2824', '1378', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2825', '1378', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2826', '1379', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2827', '1379', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2828', '1380', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2829', '1380', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2830', '1381', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2831', '1381', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2832', '1382', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2833', '1382', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2834', '1383', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2835', '1383', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2836', '1384', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2837', '1384', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2838', '1385', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2839', '1385', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2840', '1386', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2841', '1386', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2842', '1387', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2843', '1387', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2844', '1388', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2845', '1388', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2846', '1389', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2847', '1389', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2848', '1390', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2849', '1390', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2850', '1391', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2851', '1391', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2852', '1392', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2853', '1392', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2854', '1393', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2855', '1393', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2856', '1394', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2857', '1394', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2858', '1395', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2859', '1395', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2860', '1396', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2861', '1396', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2862', '1397', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2863', '1397', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2864', '1398', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2865', '1398', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2866', '1399', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2867', '1399', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2868', '1400', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2869', '1400', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2870', '1401', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2871', '1401', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2872', '1402', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2873', '1402', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2874', '1403', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2875', '1403', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2876', '1404', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2877', '1404', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2878', '1405', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2879', '1405', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2880', '1406', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2881', '1406', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2882', '1407', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2883', '1407', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2884', '1408', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2885', '1408', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2886', '1409', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2887', '1409', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2888', '1410', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2889', '1410', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2890', '1411', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2891', '1411', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2892', '1412', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2893', '1412', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2894', '1413', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2895', '1413', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2896', '1414', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2897', '1414', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2898', '1415', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2899', '1415', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2900', '1416', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2901', '1416', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2902', '1417', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2903', '1417', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2904', '1418', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2905', '1418', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2906', '1419', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2907', '1419', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2908', '1420', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2909', '1420', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2910', '1421', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2911', '1421', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2912', '1422', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2913', '1422', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2914', '1423', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2915', '1423', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2916', '1424', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2917', '1424', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2918', '1425', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2919', '1425', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2920', '1426', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2921', '1426', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2922', '1427', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2923', '1427', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2924', '1428', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2925', '1428', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2926', '1429', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2927', '1429', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2928', '1430', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2929', '1430', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2930', '1431', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2931', '1431', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2932', '1432', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2933', '1432', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2934', '1433', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2935', '1433', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2936', '1434', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2937', '1434', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2938', '1435', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2939', '1435', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2940', '1436', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2941', '1436', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2942', '1437', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2943', '1437', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2944', '1438', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2945', '1438', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2946', '1439', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2947', '1439', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2948', '1440', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2949', '1440', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2950', '1441', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2951', '1441', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2952', '1442', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2953', '1442', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2954', '1443', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2955', '1443', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2956', '1444', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2957', '1444', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2958', '1445', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2959', '1445', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2960', '1446', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2961', '1446', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2962', '1447', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2963', '1447', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2964', '1448', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2965', '1448', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2966', '1449', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2967', '1449', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2968', '1450', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2969', '1450', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2970', '1451', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2971', '1451', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2972', '1452', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2973', '1452', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2974', '1453', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2975', '1453', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2976', '1454', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2977', '1454', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2978', '1455', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2979', '1455', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2980', '1456', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2981', '1456', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2982', '1457', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2983', '1457', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2984', '1458', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2985', '1458', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2986', '1459', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2987', '1459', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2988', '1460', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2989', '1460', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2990', '1461', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2991', '1461', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2992', '1462', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2993', '1462', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2994', '1463', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2995', '1463', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2996', '1464', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2997', '1464', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2998', '1465', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('2999', '1465', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3000', '1466', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3001', '1466', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3002', '1467', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3003', '1467', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3004', '1468', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3005', '1468', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3006', '1469', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3007', '1469', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3008', '1470', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3009', '1470', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3010', '1471', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3011', '1471', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3012', '1472', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3013', '1472', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3014', '1473', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3015', '1473', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3016', '1474', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3017', '1474', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3018', '1475', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3019', '1475', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3020', '1476', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3021', '1476', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3022', '1477', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3023', '1477', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3024', '1478', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3025', '1478', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3026', '1479', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3027', '1479', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3028', '1480', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3029', '1480', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3030', '1481', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3031', '1481', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3032', '1482', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3033', '1482', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3034', '1483', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3035', '1483', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3036', '1484', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3037', '1484', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3038', '1485', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3039', '1485', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3040', '1486', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3041', '1486', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3042', '1487', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3043', '1487', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3044', '1488', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3045', '1488', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3046', '1489', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3047', '1489', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3048', '1490', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3049', '1490', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3050', '1491', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3051', '1491', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3052', '1492', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3053', '1492', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3054', '1493', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3055', '1493', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3056', '1494', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3057', '1494', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3058', '1495', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3059', '1495', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3060', '1496', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3061', '1496', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3062', '1497', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3063', '1497', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3064', '1498', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3065', '1498', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3066', '1499', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3067', '1499', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3068', '1500', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3069', '1500', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3070', '1501', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3071', '1501', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3072', '1502', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3073', '1502', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3074', '1503', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3075', '1503', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3076', '1504', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3077', '1504', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3078', '1505', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3079', '1505', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3080', '1506', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3081', '1506', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3082', '1507', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3083', '1507', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3084', '1508', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3085', '1508', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3086', '1509', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3087', '1509', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3088', '1510', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3089', '1510', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3090', '1511', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3091', '1511', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3092', '1512', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3093', '1512', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3094', '1513', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3095', '1513', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3096', '1514', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3097', '1514', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3098', '1515', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3099', '1515', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3100', '1516', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3101', '1516', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3102', '1517', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3103', '1517', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3104', '1518', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3105', '1518', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3106', '1519', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3107', '1519', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3108', '1520', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3109', '1520', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3110', '1521', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3111', '1521', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3112', '1522', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3113', '1522', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3114', '1523', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3115', '1523', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3116', '1524', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3117', '1524', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3118', '1525', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3119', '1525', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3120', '1526', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3121', '1526', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3122', '1527', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3123', '1527', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3124', '1528', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3125', '1528', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3126', '1529', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3127', '1529', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3128', '1530', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3129', '1530', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3130', '1531', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3131', '1531', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3132', '1532', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3133', '1532', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3134', '1533', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3135', '1533', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3136', '1534', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3137', '1534', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3138', '1535', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3139', '1535', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3140', '1536', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3141', '1536', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3142', '1537', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3143', '1537', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3144', '1538', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3145', '1538', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3146', '1539', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3147', '1539', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3148', '1540', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3149', '1540', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3150', '1541', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3151', '1541', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3152', '1542', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3153', '1542', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3154', '1543', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3155', '1543', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3156', '1544', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3157', '1544', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3158', '1545', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3159', '1545', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3160', '1546', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3161', '1546', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3162', '1547', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3163', '1547', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3164', '1548', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3165', '1548', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3166', '1549', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3167', '1549', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3168', '1550', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3169', '1550', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3170', '1551', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3171', '1551', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3172', '1552', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3173', '1552', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3174', '1553', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3175', '1553', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3176', '1554', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3177', '1554', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3178', '1555', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3179', '1555', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3180', '1556', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3181', '1556', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3182', '1557', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3183', '1557', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3184', '1558', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3185', '1558', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3186', '1559', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3187', '1559', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3188', '1560', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3189', '1560', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3190', '1561', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3191', '1561', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3192', '1562', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3193', '1562', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3194', '1563', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3195', '1563', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3196', '1564', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3197', '1564', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3198', '1565', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3199', '1565', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3200', '1566', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3201', '1566', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3202', '1567', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3203', '1567', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3204', '1568', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3205', '1568', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3206', '1569', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3207', '1569', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3208', '1570', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3209', '1570', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3210', '1571', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3211', '1571', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3212', '1572', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3213', '1572', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3214', '1573', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3215', '1573', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3216', '1574', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3217', '1574', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3218', '1575', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3219', '1575', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3220', '1576', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3221', '1576', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3222', '1577', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3223', '1577', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3224', '1578', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3225', '1578', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3226', '1579', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3227', '1579', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3228', '1580', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3229', '1580', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3230', '1581', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3231', '1581', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3232', '1582', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3233', '1582', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3234', '1583', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3235', '1583', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3236', '1584', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3237', '1584', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3238', '1585', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3239', '1585', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3240', '1586', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3241', '1586', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3242', '1587', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3243', '1587', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3244', '1588', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3245', '1588', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3246', '1589', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3247', '1589', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3248', '1590', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3249', '1590', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3250', '1591', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3251', '1591', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3252', '1592', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3253', '1592', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3254', '1593', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3255', '1593', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3256', '1594', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3257', '1594', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3258', '1595', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3259', '1595', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3260', '1596', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3261', '1596', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3262', '1597', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3263', '1597', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3264', '15', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3265', '1598', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3266', '1598', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3267', '1599', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3268', '1599', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3269', '1600', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3270', '1600', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3271', '1601', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3272', '1601', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3273', '1602', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3274', '1602', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3275', '1603', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3276', '1603', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3277', '1604', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3278', '1604', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3279', '1605', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3280', '1605', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3281', '1606', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3282', '1606', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3283', '1607', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3284', '1607', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3285', '1608', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3286', '1608', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3287', '1609', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3288', '1609', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3289', '1610', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3290', '1610', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3291', '1611', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3292', '1611', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3293', '1612', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3294', '1612', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3295', '1613', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3296', '1613', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3297', '1614', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3298', '1614', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3299', '1615', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3300', '1615', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3301', '1616', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3302', '1616', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3303', '1617', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3304', '1617', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3305', '1618', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3306', '1618', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3307', '1619', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3308', '1619', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3309', '1620', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3310', '1620', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3311', '1621', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3312', '1621', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3313', '1622', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3314', '1622', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3315', '1623', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3316', '1623', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3317', '1624', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3318', '1624', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3319', '1625', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3320', '1625', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3321', '1626', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3322', '1626', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3323', '1627', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3324', '1627', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3325', '1628', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3326', '1628', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3327', '1629', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3328', '1629', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3329', '1630', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3330', '1630', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3331', '1631', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3332', '1631', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3333', '1632', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3334', '1632', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3335', '1633', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3336', '1633', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3337', '1634', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3338', '1634', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3339', '1635', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3340', '1635', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3341', '1636', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3342', '1636', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3343', '1637', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3344', '1637', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3345', '1638', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3346', '1638', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3347', '1639', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3348', '1639', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3349', '1640', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3350', '1640', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3351', '1641', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3352', '1641', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3353', '1642', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3354', '1642', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3355', '1643', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3356', '1643', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3357', '1644', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3358', '1644', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3359', '1645', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3360', '1645', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3361', '1646', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3362', '1646', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3363', '1647', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3364', '1647', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3365', '1648', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3366', '1648', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3367', '1649', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3368', '1649', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3369', '1650', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3370', '1650', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3371', '1651', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3372', '1651', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3373', '1652', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3374', '1652', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3375', '1653', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3376', '1653', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3377', '1654', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3378', '1654', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3379', '1655', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3380', '1655', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3381', '1656', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3382', '1656', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3383', '1657', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3384', '1657', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3385', '1658', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3386', '1658', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3387', '1659', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3388', '1659', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3389', '1660', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3390', '1660', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3391', '1661', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3392', '1661', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3393', '1662', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3394', '1662', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3395', '1663', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3396', '1663', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3397', '1664', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3398', '1664', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3399', '1665', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3400', '1665', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3401', '1666', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3402', '1666', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3403', '1667', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3404', '1667', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3405', '1668', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3406', '1668', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3407', '1669', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3408', '1669', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3409', '1670', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3410', '1670', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3411', '1671', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3412', '1671', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3413', '1672', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3414', '1672', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3415', '1673', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3416', '1673', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3417', '1674', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3418', '1674', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3419', '1675', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3420', '1675', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3421', '1676', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3422', '1676', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3423', '1677', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3424', '1677', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3425', '1678', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3426', '1678', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3427', '1679', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3428', '1679', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3429', '1680', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3430', '1680', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3431', '1681', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3432', '1681', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3433', '1682', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3434', '1682', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3435', '1683', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3436', '1683', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3437', '1684', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3438', '1684', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3439', '1685', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3440', '1685', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3441', '1686', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3442', '1686', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3443', '1687', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3444', '1687', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3445', '1688', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3446', '1688', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3447', '1689', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3448', '1689', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3449', '1690', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3450', '1690', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3451', '1691', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3452', '1691', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3453', '1692', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3454', '1692', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3455', '1693', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3456', '1693', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3457', '1694', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3458', '1694', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3459', '1695', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3460', '1695', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3461', '55', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3462', '1696', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3463', '1696', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3464', '1697', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3465', '1697', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3466', '1698', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3467', '1698', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3468', '1699', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3469', '1699', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3470', '1700', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3471', '1700', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3472', '1701', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3473', '1701', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3474', '1702', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3475', '1702', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3476', '1703', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3477', '1703', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3478', '1704', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3479', '1704', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3480', '1705', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3481', '1705', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3482', '1706', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3483', '1706', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3484', '1707', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3485', '1707', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3486', '1708', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3487', '1708', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3488', '1709', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3489', '1709', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3490', '1710', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3491', '1710', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3492', '1711', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3493', '1711', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3494', '1712', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3495', '1712', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3496', '1713', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3497', '1713', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3498', '1714', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3499', '1714', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3500', '1715', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3501', '1715', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3502', '1716', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3503', '1716', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3504', '1717', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3505', '1717', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3506', '1718', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3507', '1718', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3508', '1719', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3509', '1719', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3510', '1720', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3511', '1720', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3512', '1721', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3513', '1721', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3514', '1722', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3515', '1722', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3516', '1723', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3517', '1723', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3518', '1724', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3519', '1724', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3520', '1725', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3521', '1725', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3522', '1726', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3523', '1726', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3524', '1727', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3525', '1727', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3526', '1728', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3527', '1728', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3528', '1729', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3529', '1729', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3530', '1730', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3531', '1730', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3532', '1731', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3533', '1731', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3534', '1732', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3535', '1732', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3536', '1733', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3537', '1733', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3538', '1734', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3539', '1734', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3540', '1735', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3541', '1735', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3542', '1736', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3543', '1736', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3544', '1737', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3545', '1737', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3546', '1738', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3547', '1738', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3548', '1739', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3549', '1739', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3550', '1740', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3551', '1740', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3552', '1741', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3553', '1741', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3554', '1742', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3555', '1742', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3556', '1743', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3557', '1743', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3558', '1744', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3559', '1744', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3560', '1745', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3561', '1745', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3562', '1746', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3563', '1746', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3564', '1747', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3565', '1747', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3566', '1748', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3567', '1748', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3568', '1749', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3569', '1749', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3570', '1750', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3571', '1750', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3572', '1751', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3573', '1751', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3574', '1752', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3575', '1752', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3576', '1753', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3577', '1753', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3578', '1754', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3579', '1754', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3580', '1755', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3581', '1755', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3582', '1756', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3583', '1756', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3584', '1757', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3585', '1757', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3586', '1758', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3587', '1758', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3588', '1759', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3589', '1759', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3590', '1760', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3591', '1760', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3592', '1761', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3593', '1761', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3594', '1762', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3595', '1762', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3596', '1763', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3597', '1763', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3598', '1764', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3599', '1764', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3600', '1765', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3601', '1765', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3602', '1766', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3603', '1766', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3604', '1767', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3605', '1767', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3606', '1768', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3607', '1768', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3608', '1769', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3609', '1769', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3610', '1770', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3611', '1770', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3612', '1771', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3613', '1771', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3614', '1772', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3615', '1772', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3616', '1773', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3617', '1773', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3618', '1774', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3619', '1774', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3620', '1775', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3621', '1775', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3622', '1776', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3623', '1776', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3624', '1777', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3625', '1777', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3626', '1778', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3627', '1778', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3628', '1779', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3629', '1779', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3630', '1780', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3631', '1780', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3632', '1781', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3633', '1781', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3634', '1782', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3635', '1782', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3636', '1783', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3637', '1783', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3638', '1784', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3639', '1784', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3640', '1785', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3641', '1785', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3642', '1786', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3643', '1786', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3644', '1787', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3645', '1787', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3646', '1788', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3647', '1788', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3648', '1789', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3649', '1789', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3650', '1790', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3651', '1790', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3652', '1791', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3653', '1791', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3654', '1792', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3655', '1792', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3656', '1793', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3657', '1793', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3658', '1794', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3659', '1794', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3660', '1795', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3661', '1795', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3662', '1796', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3663', '1796', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3664', '1797', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3665', '1797', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3666', '1798', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3667', '1798', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3668', '1799', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3669', '1799', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3670', '1800', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3671', '1800', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3672', '1801', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3673', '1801', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3674', '1802', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3675', '1802', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3676', '1803', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3677', '1803', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3678', '1804', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3679', '1804', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3680', '1805', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3681', '1805', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3682', '1806', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3683', '1806', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3684', '1807', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3685', '1807', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3686', '1808', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3687', '1808', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3688', '1809', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3689', '1809', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3690', '1810', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3691', '1810', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3692', '1811', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3693', '1811', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3694', '1812', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3695', '1812', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3696', '1813', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3697', '1813', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3698', '1814', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3699', '1814', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3700', '1815', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3701', '1815', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3702', '1816', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3703', '1816', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3704', '1817', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3705', '1817', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3706', '1818', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3707', '1818', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3708', '1819', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3709', '1819', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3710', '1820', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3711', '1820', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3712', '1821', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3713', '1821', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3714', '1822', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3715', '1822', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3716', '1823', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3717', '1823', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3718', '1824', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3719', '1824', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3720', '1825', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3721', '1825', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3722', '1826', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3723', '1826', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3724', '1827', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3725', '1827', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3726', '1828', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3727', '1828', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3728', '1829', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3729', '1829', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3730', '1830', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3731', '1830', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3732', '1831', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3733', '1831', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3734', '1832', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3735', '1832', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3736', '1833', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3737', '1833', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3738', '1834', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3739', '1834', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3740', '1835', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3741', '1835', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3742', '1836', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3743', '1836', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3744', '1837', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3745', '1837', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3746', '1838', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3747', '1838', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3748', '1839', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3749', '1839', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3750', '1840', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3751', '1840', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3752', '1841', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3753', '1841', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3754', '1842', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3755', '1842', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3756', '1843', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3757', '1843', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3758', '1844', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3759', '1844', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3760', '1845', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3761', '1845', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3762', '1846', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3763', '1846', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3764', '1847', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3765', '1847', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3766', '1848', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3767', '1848', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3768', '1849', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3769', '1849', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3770', '1850', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3771', '1850', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3772', '1851', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3773', '1851', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3774', '1852', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3775', '1852', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3776', '1853', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3777', '1853', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3778', '1854', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3779', '1854', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3780', '1855', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3781', '1855', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3782', '1856', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3783', '1856', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3784', '1857', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3785', '1857', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3786', '1858', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3787', '1858', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3788', '1859', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3789', '1859', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3790', '1860', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3791', '1860', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3792', '1861', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3793', '1861', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3794', '1862', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3795', '1862', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3796', '1863', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3797', '1863', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3798', '1864', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3799', '1864', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3800', '1865', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3801', '1865', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3802', '1866', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3803', '1866', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3804', '1867', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3805', '1867', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3806', '1868', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3807', '1868', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3808', '1869', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3809', '1869', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3810', '1870', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3811', '1870', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3812', '1871', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3813', '1871', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3814', '1872', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3815', '1872', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3816', '1873', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3817', '1873', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3818', '1874', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3819', '1874', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3820', '1875', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3821', '1875', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3822', '1876', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3823', '1876', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3824', '1877', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3825', '1877', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3826', '1878', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3827', '1878', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3828', '1879', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3829', '1879', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3830', '1880', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3831', '1880', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3832', '1881', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3833', '1881', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3834', '1882', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3835', '1882', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3836', '1883', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3837', '1883', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3838', '1884', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3839', '1884', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3840', '1885', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3841', '1885', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3842', '1886', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3843', '1886', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3844', '1887', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3845', '1887', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3846', '1888', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3847', '1888', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3848', '1889', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3849', '1889', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3850', '1890', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3851', '1890', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3852', '1891', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3853', '1891', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3854', '1892', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3855', '1892', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3856', '1893', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3857', '1893', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3858', '1894', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3859', '1894', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3860', '1895', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3861', '1895', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3862', '1896', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3863', '1896', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3864', '1897', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3865', '1897', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3866', '1898', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3867', '1898', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3868', '1899', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3869', '1899', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3870', '1900', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3871', '1900', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3872', '1901', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3873', '1901', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3874', '1902', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3875', '1902', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3876', '1903', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3877', '1903', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3878', '1904', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3879', '1904', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3880', '1905', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3881', '1905', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3882', '1906', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3883', '1906', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3884', '1907', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3885', '1907', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3886', '1908', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3887', '1908', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3888', '1909', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3889', '1909', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3890', '1910', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3891', '1910', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3892', '1911', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3893', '1911', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3894', '1912', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3895', '1912', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3896', '1913', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3897', '1913', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3898', '1914', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3899', '1914', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3900', '1915', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3901', '1915', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3902', '1916', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3903', '1916', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3904', '1917', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3905', '1917', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3906', '1918', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3907', '1918', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3908', '1919', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3909', '1919', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3910', '1920', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3911', '1920', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3912', '1921', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3913', '1921', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3914', '1922', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3915', '1922', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3916', '1923', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3917', '1923', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3918', '1924', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3919', '1924', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3920', '1925', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3921', '1925', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3922', '1926', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3923', '1926', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3924', '1927', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3925', '1927', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3926', '1928', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3927', '1928', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3928', '1929', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3929', '1929', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3930', '1930', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3931', '1930', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3932', '1931', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3933', '1931', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3934', '1932', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3935', '1932', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3936', '1933', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3937', '1933', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3938', '1934', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3939', '1934', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3940', '1935', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3941', '1935', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3942', '1936', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3943', '1936', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3944', '1937', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3945', '1937', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3946', '1938', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3947', '1938', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3948', '1939', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3949', '1939', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3950', '1940', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3951', '1940', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3952', '1941', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3953', '1941', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3954', '1942', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3955', '1942', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3956', '1943', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3957', '1943', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3958', '1944', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3959', '1944', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3960', '1945', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3961', '1945', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3962', '1946', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3963', '1946', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3964', '1947', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3965', '1947', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3966', '1948', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3967', '1948', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3968', '1949', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3969', '1949', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3970', '1950', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3971', '1950', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3972', '1951', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3973', '1951', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3974', '1952', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3975', '1952', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3976', '1953', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3977', '1953', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3978', '1954', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3979', '1954', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3980', '1955', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3981', '1955', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3982', '1956', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3983', '1956', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3984', '1957', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3985', '1957', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3986', '1958', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3987', '1958', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3988', '1959', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3989', '1959', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3990', '1960', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3991', '1960', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3992', '1961', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3993', '1961', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3994', '1962', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3995', '1962', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3996', '1963', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3997', '1963', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3998', '1964', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('3999', '1964', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4000', '1965', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4001', '1965', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4002', '1966', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4003', '1966', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4004', '1967', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4005', '1967', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4006', '1968', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4007', '1968', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4008', '1969', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4009', '1969', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4010', '1970', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4011', '1970', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4012', '1971', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4013', '1971', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4014', '1972', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4015', '1972', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4016', '1973', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4017', '1973', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4018', '1974', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4019', '1974', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4020', '1975', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4021', '1975', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4022', '1976', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4023', '1976', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4024', '1977', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4025', '1977', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4026', '1978', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4027', '1978', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4028', '1979', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4029', '1979', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4030', '1980', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4031', '1980', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4032', '1981', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4033', '1981', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4034', '1982', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4035', '1982', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4036', '1983', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4037', '1983', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4038', '1984', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4039', '1984', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4040', '1985', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4041', '1985', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4042', '1986', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4043', '1986', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4044', '1987', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4045', '1987', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4046', '1988', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4047', '1988', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4048', '1989', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4049', '1989', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4050', '1990', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4051', '1990', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4052', '1991', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4053', '1991', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4054', '1992', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4055', '1992', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4056', '1993', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4057', '1993', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4058', '1994', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4059', '1994', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4060', '1995', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4061', '1995', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4062', '1996', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4063', '1996', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4064', '1997', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4065', '1997', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4066', '1998', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4067', '1998', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4068', '16', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4069', '1999', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4070', '1999', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4071', '2000', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4072', '2000', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4073', '2001', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4074', '2001', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4075', '2002', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4076', '2002', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4077', '2003', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4078', '2003', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4079', '2004', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4080', '2004', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4081', '2005', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4082', '2005', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4083', '2006', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4084', '2006', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4085', '2007', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4086', '2007', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4087', '2008', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4088', '2008', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4089', '2009', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4090', '2009', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4091', '2010', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4092', '2010', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4093', '2011', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4094', '2011', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4095', '2012', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4096', '2012', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4097', '2013', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4098', '2013', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4099', '2014', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4100', '2014', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4101', '2015', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4102', '2015', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4103', '2016', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4104', '2016', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4105', '2017', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4106', '2017', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4107', '2018', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4108', '2018', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4109', '2019', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4110', '2019', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4111', '2020', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4112', '2020', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4113', '2021', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4114', '2021', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4115', '2022', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4116', '2022', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4117', '2023', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4118', '2023', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4119', '2024', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4120', '2024', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4121', '2025', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4122', '2025', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4123', '2026', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4124', '2026', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4125', '2027', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4126', '2027', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4127', '2028', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4128', '2028', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4129', '2029', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4130', '2029', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4131', '2030', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4132', '2030', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4133', '2031', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4134', '2031', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4135', '2032', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4136', '2032', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4137', '2033', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4138', '2033', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4139', '2034', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4140', '2034', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4141', '2035', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4142', '2035', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4143', '2036', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4144', '2036', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4145', '2037', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4146', '2037', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4147', '2038', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4148', '2038', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4149', '2039', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4150', '2039', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4151', '2040', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4152', '2040', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4153', '2041', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4154', '2041', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4155', '2042', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4156', '2042', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4157', '2043', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4158', '2043', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4159', '2044', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4160', '2044', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4161', '2045', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4162', '2045', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4163', '2046', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4164', '2046', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4165', '2047', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4166', '2047', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4167', '2048', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4168', '2048', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4169', '2049', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4170', '2049', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4171', '2050', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4172', '2050', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4173', '56', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4174', '2051', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4175', '2051', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4176', '2052', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4177', '2052', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4178', '2053', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4179', '2053', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4180', '2054', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4181', '2054', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4182', '2055', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4183', '2055', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4184', '2056', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4185', '2056', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4186', '2057', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4187', '2057', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4188', '2058', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4189', '2058', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4190', '2059', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4191', '2059', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4192', '2060', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4193', '2060', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4194', '2061', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4195', '2061', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4196', '2062', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4197', '2062', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4198', '2063', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4199', '2063', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4200', '2064', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4201', '2064', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4202', '2065', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4203', '2065', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4204', '2066', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4205', '2066', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4206', '2067', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4207', '2067', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4208', '2068', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4209', '2068', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4210', '2069', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4211', '2069', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4212', '2070', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4213', '2070', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4214', '2071', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4215', '2071', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4216', '2072', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4217', '2072', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4218', '2073', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4219', '2073', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4220', '2074', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4221', '2074', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4222', '2075', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4223', '2075', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4224', '2076', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4225', '2076', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4226', '2077', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4227', '2077', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4228', '2078', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4229', '2078', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4230', '2079', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4231', '2079', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4232', '2080', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4233', '2080', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4234', '2081', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4235', '2081', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4236', '2082', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4237', '2082', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4238', '2083', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4239', '2083', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4240', '2084', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4241', '2084', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4242', '2085', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4243', '2085', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4244', '2086', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4245', '2086', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4246', '2087', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4247', '2087', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4248', '2088', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4249', '2088', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4250', '2089', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4251', '2089', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4252', '2090', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4253', '2090', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4254', '2091', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4255', '2091', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4256', '2092', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4257', '2092', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4258', '2093', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4259', '2093', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4260', '2094', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4261', '2094', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4262', '2095', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4263', '2095', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4264', '2096', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4265', '2096', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4266', '2097', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4267', '2097', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4268', '2098', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4269', '2098', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4270', '2099', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4271', '2099', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4272', '2100', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4273', '2100', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4274', '2101', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4275', '2101', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4276', '2102', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4277', '2102', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4278', '2103', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4279', '2103', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4280', '2104', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4281', '2104', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4282', '2105', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4283', '2105', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4284', '2106', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4285', '2106', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4286', '2107', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4287', '2107', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4288', '2108', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4289', '2108', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4290', '2109', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4291', '2109', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4292', '2110', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4293', '2110', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4294', '2111', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4295', '2111', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4296', '2112', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4297', '2112', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4298', '2113', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4299', '2113', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4300', '2114', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4301', '2114', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4302', '2115', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4303', '2115', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4304', '2116', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4305', '2116', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4306', '2117', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4307', '2117', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4308', '2118', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4309', '2118', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4310', '2119', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4311', '2119', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4312', '2120', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4313', '2120', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4314', '2121', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4315', '2121', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4316', '2122', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4317', '2122', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4318', '2123', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4319', '2123', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4320', '2124', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4321', '2124', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4322', '2125', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4323', '2125', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4324', '2126', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4325', '2126', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4326', '2127', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4327', '2127', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4328', '2128', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4329', '2128', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4330', '2129', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4331', '2129', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4332', '2130', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4333', '2130', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4334', '2131', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4335', '2131', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4336', '2132', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4337', '2132', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4338', '2133', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4339', '2133', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4340', '2134', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4341', '2134', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4342', '2135', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4343', '2135', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4344', '2136', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4345', '2136', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4346', '2137', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4347', '2137', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4348', '2138', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4349', '2138', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4350', '2139', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4351', '2139', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4352', '2140', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4353', '2140', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4354', '2141', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4355', '2141', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4356', '2142', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4357', '2142', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4358', '2143', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4359', '2143', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4360', '2144', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4361', '2144', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4362', '2145', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4363', '2145', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4364', '2146', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4365', '2146', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4366', '2147', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4367', '2147', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4368', '2148', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4369', '2148', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4370', '2149', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4371', '2149', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4372', '2150', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4373', '2150', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4374', '2151', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4375', '2151', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4376', '2152', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4377', '2152', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4378', '2153', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4379', '2153', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4380', '2154', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4381', '2154', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4382', '2155', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4383', '2155', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4384', '2156', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4385', '2156', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4386', '2157', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4387', '2157', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4388', '2158', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4389', '2158', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4390', '2159', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4391', '2159', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4392', '2160', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4393', '2160', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4394', '2161', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4395', '2161', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4396', '2162', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4397', '2162', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4398', '2163', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4399', '2163', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4400', '2164', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4401', '2164', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4402', '2165', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4403', '2165', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4404', '2166', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4405', '2166', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4406', '2167', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4407', '2167', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4408', '2168', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4409', '2168', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4410', '2169', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4411', '2169', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4412', '2170', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4413', '2170', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4414', '2171', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4415', '2171', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4416', '2172', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4417', '2172', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4418', '2173', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4419', '2173', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4420', '2174', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4421', '2174', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4422', '2175', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4423', '2175', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4424', '2176', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4425', '2176', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4426', '2177', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4427', '2177', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4428', '2178', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4429', '2178', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4430', '2179', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4431', '2179', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4432', '2180', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4433', '2180', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4434', '2181', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4435', '2181', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4436', '2182', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4437', '2182', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4438', '2183', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4439', '2183', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4440', '2184', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4441', '2184', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4442', '2185', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4443', '2185', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4444', '2186', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4445', '2186', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4446', '2187', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4447', '2187', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4448', '2188', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4449', '2188', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4450', '2189', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4451', '2189', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4452', '2190', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4453', '2190', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4454', '2191', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4455', '2191', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4456', '2192', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4457', '2192', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4458', '2193', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4459', '2193', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4460', '2194', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4461', '2194', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4462', '2195', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4463', '2195', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4464', '2196', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4465', '2196', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4466', '2197', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4467', '2197', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4468', '2198', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4469', '2198', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4470', '2199', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4471', '2199', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4472', '2200', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4473', '2200', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4474', '2201', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4475', '2201', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4476', '2202', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4477', '2202', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4478', '2203', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4479', '2203', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4480', '2204', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4481', '2204', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4482', '2205', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4483', '2205', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4484', '2206', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4485', '2206', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4486', '2207', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4487', '2207', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4488', '2208', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4489', '2208', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4490', '2209', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4491', '2209', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4492', '2210', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4493', '2210', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4494', '2211', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4495', '2211', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4496', '2212', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4497', '2212', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4498', '2213', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4499', '2213', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4500', '2214', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4501', '2214', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4502', '2215', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4503', '2215', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4504', '2216', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4505', '2216', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4506', '2217', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4507', '2217', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4508', '2218', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4509', '2218', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4510', '2219', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4511', '2219', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4512', '2220', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4513', '2220', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4514', '2221', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4515', '2221', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4516', '2222', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4517', '2222', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4518', '2223', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4519', '2223', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4520', '2224', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4521', '2224', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4522', '2225', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4523', '2225', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4524', '2226', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4525', '2226', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4526', '2227', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4527', '2227', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4528', '2228', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4529', '2228', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4530', '2229', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4531', '2229', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4532', '2230', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4533', '2230', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4534', '2231', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4535', '2231', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4536', '2232', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4537', '2232', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4538', '2233', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4539', '2233', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4540', '2234', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4541', '2234', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4542', '2235', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4543', '2235', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4544', '2236', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4545', '2236', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4546', '2237', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4547', '2237', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4548', '2238', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4549', '2238', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4550', '2239', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4551', '2239', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4552', '2240', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4553', '2240', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4554', '17', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4555', '2241', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4556', '2241', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4557', '2242', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4558', '2242', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4559', '2243', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4560', '2243', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4561', '2244', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4562', '2244', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4563', '2245', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4564', '2245', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4565', '2246', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4566', '2246', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4567', '2247', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4568', '2247', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4569', '2248', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4570', '2248', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4571', '2249', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4572', '2249', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4573', '2250', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4574', '2250', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4575', '2251', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4576', '2251', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4577', '2252', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4578', '2252', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4579', '2253', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4580', '2253', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4581', '2254', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4582', '2254', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4583', '2255', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4584', '2255', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4585', '2256', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4586', '2256', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4587', '2257', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4588', '2257', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4589', '2258', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4590', '2258', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4591', '2259', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4592', '2259', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4593', '2260', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4594', '2260', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4595', '2261', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4596', '2261', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4597', '2262', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4598', '2262', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4599', '2263', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4600', '2263', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4601', '2264', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4602', '2264', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4603', '2265', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4604', '2265', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4605', '2266', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4606', '2266', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4607', '2267', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4608', '2267', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4609', '2268', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4610', '2268', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4611', '2269', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4612', '2269', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4613', '2270', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4614', '2270', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4615', '2271', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4616', '2271', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4617', '2272', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4618', '2272', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4619', '2273', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4620', '2273', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4621', '2274', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4622', '2274', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4623', '2275', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4624', '2275', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4625', '18', 'FP', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4626', '2276', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4627', '2276', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4628', '2277', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4629', '2277', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4630', '2278', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4631', '2278', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4632', '2279', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4633', '2279', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4634', '2280', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4635', '2280', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4636', '2281', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4637', '2281', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4638', '2282', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4639', '2282', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4640', '2283', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4641', '2283', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4642', '2284', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4643', '2284', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4644', '2285', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4645', '2285', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4646', '2286', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4647', '2286', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4648', '2287', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4649', '2287', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4650', '2288', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4651', '2288', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4652', '2289', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4653', '2289', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4654', '2290', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4655', '2290', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4656', '2291', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4657', '2291', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4658', '2292', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4659', '2292', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4660', '2293', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4661', '2293', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4662', '2294', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4663', '2294', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4664', '2295', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4665', '2295', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4666', '2296', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4667', '2296', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4668', '2297', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4669', '2297', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4670', '2298', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4671', '2298', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4672', '2299', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4673', '2299', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4674', '2300', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4675', '2300', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4676', '2301', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4677', '2301', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4678', '2302', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4679', '2302', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4680', '2303', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4681', '2303', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4682', '2304', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4683', '2304', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4684', '2305', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4685', '2305', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4686', '2306', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4687', '2306', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4688', '2307', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4689', '2307', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4690', '2308', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4691', '2308', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4692', '2309', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4693', '2309', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4694', '2310', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4695', '2310', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4696', '2311', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4697', '2311', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4698', '2312', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4699', '2312', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4700', '2313', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4701', '2313', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4702', '2314', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4703', '2314', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4704', '2315', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4705', '2315', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4706', '2316', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4707', '2316', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4708', '2317', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4709', '2317', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4710', '2318', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4711', '2318', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4712', '2319', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4713', '2319', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4714', '2320', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4715', '2320', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4716', '2321', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4717', '2321', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4718', '2322', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4719', '2322', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4720', '2323', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4721', '2323', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4722', '2324', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4723', '2324', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4724', '2325', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4725', '2325', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4726', '2326', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4727', '2326', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4728', '2327', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4729', '2327', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4730', '2328', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4731', '2328', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4732', '2329', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4733', '2329', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4734', '2330', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4735', '2330', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4736', '2331', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4737', '2331', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4738', '2332', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4739', '2332', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4740', '2333', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4741', '2333', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4742', '2334', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4743', '2334', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4744', '2335', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4745', '2335', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4746', '2336', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4747', '2336', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4748', '2337', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4749', '2337', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4750', '2338', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4751', '2338', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4752', '2339', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4753', '2339', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4754', '2340', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4755', '2340', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4756', '2341', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4757', '2341', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4758', '2342', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4759', '2342', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4760', '2343', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4761', '2343', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4762', '2344', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4763', '2344', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4764', '2345', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4765', '2345', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4766', '2346', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4767', '2346', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4768', '2347', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4769', '2347', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4770', '2348', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4771', '2348', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4772', '2349', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4773', '2349', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4774', '2350', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4775', '2350', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4776', '2351', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4777', '2351', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4778', '2352', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4779', '2352', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4780', '2353', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4781', '2353', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4782', '2354', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4783', '2354', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4784', '2355', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4785', '2355', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4786', '2356', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4787', '2356', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4788', '2357', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4789', '2357', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4790', '2358', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4791', '2358', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4792', '2359', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4793', '2359', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4794', '2360', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4795', '2360', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4796', '2361', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4797', '2361', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4798', '2362', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4799', '2362', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4800', '2363', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4801', '2363', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4802', '2364', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4803', '2364', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4804', '2365', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4805', '2365', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4806', '2366', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4807', '2366', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4808', '2367', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4809', '2367', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4810', '2368', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4811', '2368', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4812', '2369', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4813', '2369', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4814', '2370', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4815', '2370', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4816', '2371', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4817', '2371', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4818', '2372', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4819', '2372', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4820', '2373', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4821', '2373', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4822', '2374', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4823', '2374', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4824', '2375', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4825', '2375', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4826', '2376', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4827', '2376', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4828', '2377', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4829', '2377', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4830', '2378', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4831', '2378', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4832', '2379', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4833', '2379', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4834', '2380', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4835', '2380', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4836', '2381', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4837', '2381', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4838', '2382', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4839', '2382', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4840', '2383', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4841', '2383', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4842', '2384', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4843', '2384', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4844', '2385', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4845', '2385', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4846', '2386', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4847', '2386', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4848', '2387', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4849', '2387', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4850', '2388', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4851', '2388', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4852', '2389', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4853', '2389', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4854', '2390', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4855', '2390', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4856', '2391', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4857', '2391', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4858', '2392', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4859', '2392', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4860', '2393', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4861', '2393', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4862', '2394', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4863', '2394', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4864', '2395', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4865', '2395', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4866', '2396', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4867', '2396', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4868', '2397', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4869', '2397', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4870', '2398', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4871', '2398', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4872', '2399', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4873', '2399', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4874', '2400', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4875', '2400', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4876', '2401', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4877', '2401', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4878', '2402', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4879', '2402', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4880', '2403', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4881', '2403', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4882', '2404', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4883', '2404', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4884', '2405', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4885', '2405', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4886', '2406', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4887', '2406', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4888', '2407', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4889', '2407', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4890', '2408', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4891', '2408', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4892', '2409', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4893', '2409', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4894', '2410', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4895', '2410', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4896', '2411', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4897', '2411', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4898', '2412', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4899', '2412', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4900', '2413', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4901', '2413', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4902', '2414', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4903', '2414', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4904', '2415', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4905', '2415', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4906', '2416', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4907', '2416', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4908', '2417', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4909', '2417', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4910', '2418', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4911', '2418', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4912', '2419', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4913', '2419', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4914', '2420', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4915', '2420', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4916', '2421', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4917', '2421', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4918', '2422', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4919', '2422', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4920', '2423', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4921', '2423', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4922', '2424', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4923', '2424', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4924', '2425', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4925', '2425', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4926', '2426', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4927', '2426', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4928', '2427', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4929', '2427', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4930', '2428', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4931', '2428', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4932', '2429', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4933', '2429', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4934', '2430', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4935', '2430', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4936', '2431', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4937', '2431', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4938', '2432', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4939', '2432', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4940', '2433', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4941', '2433', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4942', '2434', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4943', '2434', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4944', '2435', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4945', '2435', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4946', '2436', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4947', '2436', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4948', '2437', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4949', '2437', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4950', '2438', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4951', '2438', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4952', '2439', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4953', '2439', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4954', '2440', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4955', '2440', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4956', '2441', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4957', '2441', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4958', '2442', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4959', '2442', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4960', '2443', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4961', '2443', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4962', '2444', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4963', '2444', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4964', '2445', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4965', '2445', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4966', '2446', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4967', '2446', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4968', '2447', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4969', '2447', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4970', '2448', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4971', '2448', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4972', '2449', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4973', '2449', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4974', '2450', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4975', '2450', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4976', '2451', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4977', '2451', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4978', '2452', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4979', '2452', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4980', '2453', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4981', '2453', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4982', '2454', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4983', '2454', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4984', '2455', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4985', '2455', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4986', '2456', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4987', '2456', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4988', '2457', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4989', '2457', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4990', '2458', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4991', '2458', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4992', '2459', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4993', '2459', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4994', '2460', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4995', '2460', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4996', '2461', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4997', '2461', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4998', '2462', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('4999', '2462', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5000', '2463', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5001', '2463', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5002', '2464', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5003', '2464', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5004', '2465', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5005', '2465', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5006', '2466', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5007', '2466', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5008', '2467', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5009', '2467', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5010', '2468', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5011', '2468', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5012', '2469', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5013', '2469', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5014', '2470', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5015', '2470', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5016', '2471', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5017', '2471', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5018', '2472', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5019', '2472', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5020', '2473', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5021', '2473', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5022', '2474', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5023', '2474', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5024', '2475', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5025', '2475', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5026', '2476', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5027', '2476', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5028', '2477', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5029', '2477', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5030', '2478', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5031', '2478', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5032', '2479', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5033', '2479', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5034', '2480', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5035', '2480', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5036', '2481', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5037', '2481', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5038', '2482', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5039', '2482', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5040', '2483', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5041', '2483', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5042', '2484', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5043', '2484', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5044', '2485', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5045', '2485', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5046', '2486', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5047', '2486', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5048', '2487', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5049', '2487', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5050', '2488', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5051', '2488', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5052', '2489', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5053', '2489', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5054', '2490', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5055', '2490', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5056', '2491', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5057', '2491', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5058', '2492', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5059', '2492', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5060', '2493', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5061', '2493', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5062', '2494', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5063', '2494', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5064', '2495', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5065', '2495', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5066', '2496', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5067', '2496', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5068', '2497', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5069', '2497', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5070', '2498', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5071', '2498', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5072', '2499', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5073', '2499', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5074', '2500', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5075', '2500', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5076', '2501', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5077', '2501', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5078', '2502', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5079', '2502', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5080', '2503', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5081', '2503', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5082', '2504', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5083', '2504', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5084', '2505', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5085', '2505', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5086', '2506', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5087', '2506', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5088', '2507', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5089', '2507', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5090', '2508', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5091', '2508', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5092', '2509', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5093', '2509', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5094', '2510', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5095', '2510', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5096', '2511', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5097', '2511', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5098', '2512', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5099', '2512', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5100', '2513', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5101', '2513', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5102', '2514', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5103', '2514', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5104', '2515', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5105', '2515', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5106', '2516', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5107', '2516', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5108', '2517', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5109', '2517', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5110', '2518', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5111', '2518', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5112', '2519', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5113', '2519', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5114', '2520', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5115', '2520', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5116', '2521', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5117', '2521', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5118', '2522', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5119', '2522', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5120', '2523', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5121', '2523', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5122', '2524', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5123', '2524', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5124', '2525', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5125', '2525', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5126', '2526', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5127', '2526', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5128', '2527', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5129', '2527', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5130', '2528', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5131', '2528', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5132', '2529', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5133', '2529', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5134', '2530', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5135', '2530', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5136', '2531', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5137', '2531', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5138', '2532', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5139', '2532', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5140', '2533', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5141', '2533', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5142', '2534', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5143', '2534', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5144', '2535', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5145', '2535', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5146', '2536', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5147', '2536', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5148', '2537', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5149', '2537', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5150', '2538', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5151', '2538', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5152', '2539', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5153', '2539', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5154', '2540', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5155', '2540', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5156', '2541', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5157', '2541', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5158', '2542', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5159', '2542', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5160', '2543', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5161', '2543', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5162', '2544', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5163', '2544', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5164', '2545', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5165', '2545', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5166', '2546', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5167', '2546', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5168', '2547', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5169', '2547', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5170', '2548', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5171', '2548', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5172', '2549', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5173', '2549', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5174', '2550', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5175', '2550', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5176', '2551', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5177', '2551', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5178', '2552', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5179', '2552', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5180', '2553', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5181', '2553', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5182', '2554', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5183', '2554', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5184', '2555', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5185', '2555', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5186', '2556', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5187', '2556', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5188', '2557', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5189', '2557', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5190', '2558', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5191', '2558', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5192', '2559', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5193', '2559', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5194', '2560', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5195', '2560', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5196', '2561', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5197', '2561', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5198', '2562', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5199', '2562', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5200', '2563', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5201', '2563', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5202', '2564', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5203', '2564', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5204', '2565', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5205', '2565', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5206', '2566', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5207', '2566', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5208', '2567', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5209', '2567', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5210', '2568', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5211', '2568', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5212', '2569', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5213', '2569', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5214', '2570', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5215', '2570', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5216', '2571', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5217', '2571', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5218', '2572', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5219', '2572', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5220', '2573', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5221', '2573', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5222', '2574', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5223', '2574', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5224', '2575', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5225', '2575', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5226', '2576', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5227', '2576', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5228', '2577', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5229', '2577', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5230', '2578', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5231', '2578', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5232', '2579', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5233', '2579', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5234', '2580', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5235', '2580', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5236', '2581', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5237', '2581', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5238', '2582', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5239', '2582', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5240', '2583', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5241', '2583', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5242', '2584', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5243', '2584', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5244', '2585', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5245', '2585', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5246', '2586', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5247', '2586', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5248', '2587', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5249', '2587', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5250', '2588', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5251', '2588', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5252', '2589', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5253', '2589', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5254', '57', 'FT', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5255', '2590', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5256', '2590', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5257', '2591', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5258', '2591', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5259', '2592', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5260', '2592', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5261', '2593', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5262', '2593', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5263', '2594', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5264', '2594', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5265', '2595', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5266', '2595', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5267', '2596', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5268', '2596', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5269', '2597', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5270', '2597', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5271', '2598', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5272', '2598', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5273', '2599', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5274', '2599', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5275', '2600', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5276', '2600', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5277', '2601', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5278', '2601', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5279', '2602', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5280', '2602', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5281', '2603', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5282', '2603', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5283', '2604', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5284', '2604', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5285', '2605', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5286', '2605', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5287', '2606', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5288', '2606', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5289', '2607', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5290', '2607', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5291', '2608', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5292', '2608', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5293', '2609', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5294', '2609', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5295', '2610', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5296', '2610', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5297', '2611', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5298', '2611', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5299', '2612', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5300', '2612', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5301', '2613', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5302', '2613', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5303', '2614', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5304', '2614', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5305', '2615', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5306', '2615', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5307', '2616', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5308', '2616', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5309', '2617', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5310', '2617', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5311', '2618', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5312', '2618', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5313', '2619', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5314', '2619', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5315', '2620', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5316', '2620', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5317', '2621', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5318', '2621', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5319', '2622', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5320', '2622', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5321', '2623', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5322', '2623', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5323', '2624', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5324', '2624', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5325', '2625', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5326', '2625', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5327', '2626', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5328', '2626', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5329', '2627', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5330', '2627', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5331', '2628', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5332', '2628', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5333', '2629', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5334', '2629', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5335', '2630', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5336', '2630', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5337', '2631', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5338', '2631', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5339', '2632', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5340', '2632', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5341', '2633', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5342', '2633', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5343', '2634', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5344', '2634', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5345', '2635', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5346', '2635', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5347', '2636', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5348', '2636', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5349', '2637', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5350', '2637', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5351', '2638', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5352', '2638', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5353', '2639', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5354', '2639', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5355', '2640', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5356', '2640', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5357', '2641', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5358', '2641', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5359', '2642', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5360', '2642', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5361', '2643', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5362', '2643', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5363', '2644', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5364', '2644', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5365', '2645', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5366', '2645', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5367', '2646', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5368', '2646', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5369', '2647', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5370', '2647', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5371', '2648', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5372', '2648', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5373', '2649', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5374', '2649', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5375', '2650', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5376', '2650', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5377', '2651', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5378', '2651', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5379', '2652', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5380', '2652', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5381', '2653', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5382', '2653', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5383', '2654', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5384', '2654', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5385', '2655', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5386', '2655', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5387', '2656', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5388', '2656', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5389', '2657', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5390', '2657', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5391', '2658', 'RC', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5392', '2658', 'FR', '2021');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5393', '1', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5394', '1', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5395', '2', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5396', '2', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5397', '3', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5398', '3', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5399', '4', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5400', '4', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5401', '5', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5402', '5', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5403', '6', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5404', '6', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5405', '7', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5406', '7', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5407', '8', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5408', '8', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5409', '9', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5410', '9', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5411', '10', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5412', '10', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5413', '11', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5414', '11', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5415', '12', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5416', '12', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5417', '13', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5418', '13', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5419', '14', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5420', '14', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5421', '15', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5422', '15', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5423', '16', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5424', '16', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5425', '17', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5426', '17', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5427', '18', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5428', '18', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5429', '19', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5430', '19', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5431', '20', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5432', '20', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5433', '21', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5434', '21', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5435', '22', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5436', '22', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5437', '23', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5438', '23', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5439', '24', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5440', '24', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5441', '25', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5442', '25', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5443', '26', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5444', '26', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5445', '27', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5446', '27', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5447', '28', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5448', '28', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5449', '29', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5450', '29', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5451', '30', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5452', '30', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5453', '31', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5454', '31', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5455', '32', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5456', '32', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5457', '33', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5458', '33', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5459', '34', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5460', '34', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5461', '35', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5462', '35', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5463', '36', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5464', '36', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5465', '37', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5466', '37', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5467', '38', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5468', '38', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5469', '39', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5470', '39', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5471', '40', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5472', '40', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5473', '41', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5474', '41', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5475', '42', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5476', '42', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5477', '43', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5478', '43', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5479', '44', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5480', '44', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5481', '45', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5482', '45', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5483', '46', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5484', '46', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5485', '47', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5486', '47', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5487', '48', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5488', '48', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5489', '49', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5490', '49', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5491', '50', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5492', '50', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5493', '51', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5494', '51', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5495', '52', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5496', '52', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5497', '53', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5498', '53', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5499', '54', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5500', '54', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5501', '55', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5502', '55', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5503', '56', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5504', '56', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5505', '57', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5506', '57', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5507', '58', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5508', '58', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5509', '59', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5510', '59', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5511', '60', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5512', '60', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5513', '61', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5514', '61', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5515', '62', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5516', '62', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5517', '63', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5518', '63', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5519', '64', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5520', '64', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5521', '65', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5522', '65', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5523', '66', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5524', '66', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5525', '67', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5526', '67', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5527', '68', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5528', '68', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5529', '69', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5530', '69', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5531', '70', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5532', '70', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5533', '71', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5534', '71', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5535', '72', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5536', '72', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5537', '73', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5538', '73', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5539', '74', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5540', '74', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5541', '75', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5542', '75', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5543', '76', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5544', '76', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5545', '77', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5546', '77', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5547', '78', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5548', '78', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5549', '79', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5550', '79', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5551', '80', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5552', '80', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5553', '81', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5554', '81', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5555', '82', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5556', '82', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5557', '83', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5558', '83', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5559', '84', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5560', '84', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5561', '85', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5562', '85', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5563', '86', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5564', '86', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5565', '87', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5566', '87', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5567', '88', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5568', '88', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5569', '89', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5570', '89', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5571', '90', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5572', '90', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5573', '91', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5574', '91', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5575', '92', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5576', '92', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5577', '93', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5578', '93', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5579', '94', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5580', '94', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5581', '95', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5582', '95', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5583', '96', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5584', '96', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5585', '97', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5586', '97', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5587', '98', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5588', '98', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5589', '99', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5590', '99', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5591', '100', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5592', '100', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5593', '101', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5594', '101', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5595', '102', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5596', '102', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5597', '103', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5598', '103', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5599', '104', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5600', '104', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5601', '105', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5602', '105', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5603', '106', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5604', '106', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5605', '107', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5606', '107', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5607', '108', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5608', '108', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5609', '109', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5610', '109', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5611', '110', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5612', '110', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5613', '111', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5614', '111', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5615', '112', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5616', '112', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5617', '113', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5618', '113', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5619', '114', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5620', '114', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5621', '115', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5622', '115', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5623', '116', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5624', '116', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5625', '117', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5626', '117', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5627', '118', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5628', '118', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5629', '119', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5630', '119', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5631', '120', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5632', '120', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5633', '121', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5634', '121', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5635', '122', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5636', '122', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5637', '123', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5638', '123', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5639', '124', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5640', '124', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5641', '125', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5642', '125', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5643', '126', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5644', '126', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5645', '127', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5646', '127', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5647', '128', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5648', '128', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5649', '129', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5650', '129', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5651', '130', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5652', '130', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5653', '131', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5654', '131', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5655', '132', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5656', '132', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5657', '133', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5658', '133', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5659', '134', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5660', '134', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5661', '135', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5662', '135', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5663', '136', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5664', '136', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5665', '137', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5666', '137', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5667', '138', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5668', '138', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5669', '139', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5670', '139', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5671', '140', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5672', '140', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5673', '141', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5674', '141', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5675', '142', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5676', '142', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5677', '143', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5678', '143', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5679', '144', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5680', '144', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5681', '145', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5682', '145', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5683', '146', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5684', '146', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5685', '147', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5686', '147', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5687', '148', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5688', '148', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5689', '149', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5690', '149', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5691', '150', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5692', '150', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5693', '151', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5694', '151', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5695', '152', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5696', '152', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5697', '153', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5698', '153', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5699', '154', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5700', '154', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5701', '155', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5702', '155', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5703', '156', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5704', '156', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5705', '157', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5706', '157', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5707', '158', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5708', '158', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5709', '159', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5710', '159', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5711', '160', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5712', '160', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5713', '161', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5714', '161', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5715', '162', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5716', '162', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5717', '163', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5718', '163', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5719', '164', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5720', '164', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5721', '165', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5722', '165', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5723', '166', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5724', '166', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5725', '167', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5726', '167', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5727', '168', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5728', '168', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5729', '169', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5730', '169', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5731', '170', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5732', '170', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5733', '171', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5734', '171', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5735', '172', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5736', '172', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5737', '173', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5738', '173', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5739', '174', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5740', '174', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5741', '175', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5742', '175', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5743', '176', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5744', '176', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5745', '177', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5746', '177', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5747', '178', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5748', '178', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5749', '179', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5750', '179', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5751', '180', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5752', '180', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5753', '181', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5754', '181', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5755', '182', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5756', '182', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5757', '183', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5758', '183', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5759', '184', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5760', '184', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5761', '185', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5762', '185', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5763', '186', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5764', '186', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5765', '187', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5766', '187', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5767', '188', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5768', '188', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5769', '189', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5770', '189', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5771', '190', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5772', '190', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5773', '191', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5774', '191', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5775', '192', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5776', '192', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5777', '193', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5778', '193', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5779', '194', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5780', '194', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5781', '195', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5782', '195', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5783', '196', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5784', '196', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5785', '197', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5786', '197', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5787', '198', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5788', '198', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5789', '199', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5790', '199', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5791', '200', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5792', '200', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5793', '201', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5794', '201', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5795', '202', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5796', '202', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5797', '203', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5798', '203', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5799', '204', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5800', '204', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5801', '205', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5802', '205', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5803', '206', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5804', '206', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5805', '207', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5806', '207', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5807', '208', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5808', '208', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5809', '209', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5810', '209', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5811', '210', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5812', '210', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5813', '211', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5814', '211', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5815', '212', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5816', '212', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5817', '213', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5818', '213', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5819', '214', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5820', '214', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5821', '215', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5822', '215', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5823', '216', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5824', '216', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5825', '217', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5826', '217', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5827', '218', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5828', '218', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5829', '219', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5830', '219', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5831', '220', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5832', '220', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5833', '221', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5834', '221', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5835', '222', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5836', '222', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5837', '223', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5838', '223', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5839', '224', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5840', '224', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5841', '225', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5842', '225', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5843', '226', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5844', '226', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5845', '227', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5846', '227', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5847', '228', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5848', '228', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5849', '229', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5850', '229', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5851', '230', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5852', '230', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5853', '231', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5854', '231', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5855', '232', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5856', '232', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5857', '233', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5858', '233', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5859', '234', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5860', '234', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5861', '235', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5862', '235', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5863', '236', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5864', '236', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5865', '237', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5866', '237', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5867', '238', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5868', '238', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5869', '239', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5870', '239', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5871', '240', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5872', '240', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5873', '241', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5874', '241', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5875', '242', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5876', '242', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5877', '243', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5878', '243', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5879', '244', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5880', '244', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5881', '245', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5882', '245', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5883', '246', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5884', '246', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5885', '247', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5886', '247', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5887', '248', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5888', '248', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5889', '249', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5890', '249', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5891', '250', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5892', '250', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5893', '251', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5894', '251', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5895', '252', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5896', '252', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5897', '253', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5898', '253', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5899', '254', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5900', '254', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5901', '255', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5902', '255', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5903', '256', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5904', '256', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5905', '257', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5906', '257', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5907', '258', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5908', '258', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5909', '259', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5910', '259', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5911', '260', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5912', '260', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5913', '261', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5914', '261', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5915', '262', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5916', '262', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5917', '263', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5918', '263', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5919', '264', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5920', '264', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5921', '265', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5922', '265', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5923', '266', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5924', '266', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5925', '267', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5926', '267', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5927', '268', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5928', '268', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5929', '269', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5930', '269', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5931', '270', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5932', '270', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5933', '271', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5934', '271', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5935', '272', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5936', '272', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5937', '273', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5938', '273', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5939', '274', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5940', '274', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5941', '275', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5942', '275', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5943', '276', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5944', '276', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5945', '277', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5946', '277', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5947', '278', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5948', '278', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5949', '279', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5950', '279', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5951', '280', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5952', '280', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5953', '281', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5954', '281', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5955', '282', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5956', '282', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5957', '283', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5958', '283', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5959', '284', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5960', '284', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5961', '285', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5962', '285', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5963', '286', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5964', '286', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5965', '287', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5966', '287', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5967', '288', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5968', '288', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5969', '289', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5970', '289', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5971', '290', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5972', '290', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5973', '291', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5974', '291', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5975', '292', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5976', '292', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5977', '293', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5978', '293', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5979', '294', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5980', '294', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5981', '295', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5982', '295', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5983', '296', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5984', '296', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5985', '297', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5986', '297', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5987', '298', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5988', '298', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5989', '299', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5990', '299', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5991', '300', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5992', '300', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5993', '301', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5994', '301', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5995', '302', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5996', '302', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5997', '303', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5998', '303', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('5999', '304', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6000', '304', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6001', '305', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6002', '305', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6003', '306', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6004', '306', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6005', '307', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6006', '307', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6007', '308', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6008', '308', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6009', '309', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6010', '309', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6011', '310', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6012', '310', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6013', '311', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6014', '311', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6015', '312', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6016', '312', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6017', '313', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6018', '313', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6019', '314', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6020', '314', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6021', '315', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6022', '315', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6023', '316', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6024', '316', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6025', '317', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6026', '317', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6027', '318', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6028', '318', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6029', '319', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6030', '319', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6031', '320', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6032', '320', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6033', '321', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6034', '321', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6035', '322', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6036', '322', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6037', '323', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6038', '323', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6039', '324', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6040', '324', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6041', '325', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6042', '325', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6043', '326', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6044', '326', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6045', '327', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6046', '327', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6047', '328', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6048', '328', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6049', '329', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6050', '329', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6051', '330', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6052', '330', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6053', '331', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6054', '331', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6055', '332', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6056', '332', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6057', '333', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6058', '333', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6059', '334', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6060', '334', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6061', '335', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6062', '335', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6063', '336', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6064', '336', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6065', '337', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6066', '337', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6067', '338', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6068', '338', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6069', '339', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6070', '339', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6071', '340', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6072', '340', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6073', '341', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6074', '341', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6075', '342', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6076', '342', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6077', '343', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6078', '343', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6079', '344', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6080', '344', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6081', '345', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6082', '345', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6083', '346', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6084', '346', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6085', '347', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6086', '347', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6087', '348', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6088', '348', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6089', '349', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6090', '349', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6091', '350', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6092', '350', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6093', '351', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6094', '351', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6095', '352', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6096', '352', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6097', '353', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6098', '353', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6099', '354', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6100', '354', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6101', '355', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6102', '355', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6103', '356', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6104', '356', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6105', '357', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6106', '357', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6107', '358', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6108', '358', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6109', '359', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6110', '359', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6111', '360', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6112', '360', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6113', '361', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6114', '361', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6115', '362', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6116', '362', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6117', '363', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6118', '363', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6119', '364', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6120', '364', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6121', '365', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6122', '365', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6123', '366', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6124', '366', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6125', '367', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6126', '367', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6127', '368', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6128', '368', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6129', '369', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6130', '369', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6131', '370', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6132', '370', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6133', '371', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6134', '371', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6135', '372', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6136', '372', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6137', '373', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6138', '373', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6139', '374', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6140', '374', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6141', '375', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6142', '375', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6143', '376', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6144', '376', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6145', '377', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6146', '377', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6147', '378', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6148', '378', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6149', '379', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6150', '379', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6151', '380', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6152', '380', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6153', '381', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6154', '381', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6155', '382', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6156', '382', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6157', '383', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6158', '383', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6159', '384', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6160', '384', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6161', '385', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6162', '385', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6163', '386', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6164', '386', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6165', '387', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6166', '387', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6167', '388', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6168', '388', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6169', '389', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6170', '389', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6171', '390', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6172', '390', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6173', '391', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6174', '391', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6175', '392', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6176', '392', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6177', '393', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6178', '393', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6179', '394', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6180', '394', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6181', '395', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6182', '395', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6183', '396', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6184', '396', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6185', '397', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6186', '397', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6187', '398', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6188', '398', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6189', '399', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6190', '399', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6191', '400', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6192', '400', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6193', '401', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6194', '401', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6195', '402', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6196', '402', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6197', '403', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6198', '403', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6199', '404', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6200', '404', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6201', '405', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6202', '405', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6203', '406', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6204', '406', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6205', '407', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6206', '407', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6207', '408', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6208', '408', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6209', '409', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6210', '409', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6211', '410', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6212', '410', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6213', '411', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6214', '411', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6215', '412', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6216', '412', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6217', '413', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6218', '413', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6219', '414', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6220', '414', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6221', '415', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6222', '415', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6223', '416', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6224', '416', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6225', '417', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6226', '417', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6227', '418', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6228', '418', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6229', '419', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6230', '419', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6231', '420', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6232', '420', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6233', '421', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6234', '421', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6235', '422', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6236', '422', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6237', '423', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6238', '423', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6239', '424', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6240', '424', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6241', '425', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6242', '425', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6243', '426', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6244', '426', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6245', '427', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6246', '427', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6247', '428', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6248', '428', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6249', '429', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6250', '429', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6251', '430', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6252', '430', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6253', '431', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6254', '431', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6255', '432', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6256', '432', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6257', '433', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6258', '433', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6259', '434', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6260', '434', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6261', '435', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6262', '435', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6263', '436', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6264', '436', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6265', '437', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6266', '437', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6267', '438', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6268', '438', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6269', '439', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6270', '439', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6271', '440', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6272', '440', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6273', '441', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6274', '441', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6275', '442', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6276', '442', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6277', '443', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6278', '443', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6279', '444', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6280', '444', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6281', '445', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6282', '445', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6283', '446', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6284', '446', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6285', '447', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6286', '447', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6287', '448', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6288', '448', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6289', '449', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6290', '449', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6291', '450', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6292', '450', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6293', '451', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6294', '451', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6295', '452', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6296', '452', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6297', '453', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6298', '453', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6299', '454', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6300', '454', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6301', '455', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6302', '455', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6303', '456', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6304', '456', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6305', '457', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6306', '457', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6307', '458', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6308', '458', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6309', '459', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6310', '459', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6311', '460', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6312', '460', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6313', '461', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6314', '461', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6315', '462', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6316', '462', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6317', '463', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6318', '463', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6319', '464', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6320', '464', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6321', '465', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6322', '465', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6323', '466', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6324', '466', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6325', '467', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6326', '467', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6327', '468', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6328', '468', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6329', '469', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6330', '469', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6331', '470', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6332', '470', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6333', '471', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6334', '471', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6335', '472', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6336', '472', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6337', '473', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6338', '473', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6339', '474', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6340', '474', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6341', '475', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6342', '475', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6343', '476', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6344', '476', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6345', '477', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6346', '477', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6347', '478', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6348', '478', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6349', '479', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6350', '479', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6351', '480', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6352', '480', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6353', '481', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6354', '481', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6355', '482', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6356', '482', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6357', '483', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6358', '483', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6359', '484', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6360', '484', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6361', '485', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6362', '485', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6363', '486', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6364', '486', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6365', '487', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6366', '487', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6367', '488', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6368', '488', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6369', '489', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6370', '489', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6371', '490', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6372', '490', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6373', '491', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6374', '491', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6375', '492', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6376', '492', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6377', '493', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6378', '493', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6379', '494', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6380', '494', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6381', '495', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6382', '495', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6383', '496', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6384', '496', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6385', '497', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6386', '497', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6387', '498', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6388', '498', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6389', '499', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6390', '499', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6391', '500', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6392', '500', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6393', '501', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6394', '501', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6395', '502', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6396', '502', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6397', '503', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6398', '503', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6399', '504', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6400', '504', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6401', '505', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6402', '505', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6403', '1', 'FT', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6404', '506', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6405', '506', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6406', '507', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6407', '507', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6408', '508', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6409', '508', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6410', '509', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6411', '509', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6412', '510', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6413', '510', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6414', '511', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6415', '511', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6416', '512', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6417', '512', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6418', '2', 'FT', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6419', '513', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6420', '513', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6421', '514', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6422', '514', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6423', '515', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6424', '515', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6425', '516', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6426', '516', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6427', '517', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6428', '517', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6429', '518', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6430', '518', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6431', '519', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6432', '519', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6433', '520', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6434', '520', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6435', '521', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6436', '521', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6437', '522', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6438', '522', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6439', '523', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6440', '523', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6441', '524', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6442', '524', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6443', '525', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6444', '525', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6445', '526', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6446', '526', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6447', '527', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6448', '527', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6449', '528', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6450', '528', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6451', '529', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6452', '529', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6453', '530', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6454', '530', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6455', '531', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6456', '531', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6457', '532', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6458', '532', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6459', '533', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6460', '533', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6461', '534', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6462', '534', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6463', '535', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6464', '535', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6465', '536', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6466', '536', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6467', '537', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6468', '537', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6469', '538', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6470', '538', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6471', '539', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6472', '539', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6473', '540', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6474', '540', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6475', '541', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6476', '541', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6477', '542', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6478', '542', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6479', '543', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6480', '543', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6481', '544', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6482', '544', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6483', '545', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6484', '545', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6485', '546', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6486', '546', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6487', '547', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6488', '547', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6489', '548', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6490', '548', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6491', '549', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6492', '549', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6493', '550', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6494', '550', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6495', '551', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6496', '551', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6497', '552', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6498', '552', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6499', '553', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6500', '553', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6501', '554', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6502', '554', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6503', '555', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6504', '555', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6505', '556', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6506', '556', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6507', '557', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6508', '557', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6509', '558', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6510', '558', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6511', '559', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6512', '559', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6513', '560', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6514', '560', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6515', '561', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6516', '561', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6517', '562', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6518', '562', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6519', '563', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6520', '563', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6521', '564', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6522', '564', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6523', '565', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6524', '565', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6525', '566', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6526', '566', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6527', '567', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6528', '567', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6529', '568', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6530', '568', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6531', '569', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6532', '569', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6533', '570', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6534', '570', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6535', '571', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6536', '571', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6537', '572', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6538', '572', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6539', '573', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6540', '573', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6541', '574', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6542', '574', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6543', '575', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6544', '575', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6545', '576', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6546', '576', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6547', '577', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6548', '577', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6549', '578', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6550', '578', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6551', '579', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6552', '579', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6553', '580', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6554', '580', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6555', '581', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6556', '581', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6557', '582', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6558', '582', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6559', '583', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6560', '583', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6561', '584', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6562', '584', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6563', '585', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6564', '585', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6565', '586', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6566', '586', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6567', '587', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6568', '587', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6569', '588', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6570', '588', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6571', '589', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6572', '589', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6573', '590', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6574', '590', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6575', '591', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6576', '591', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6577', '592', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6578', '592', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6579', '593', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6580', '593', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6581', '594', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6582', '594', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6583', '595', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6584', '595', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6585', '596', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6586', '596', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6587', '597', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6588', '597', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6589', '598', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6590', '598', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6591', '599', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6592', '599', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6593', '600', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6594', '600', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6595', '601', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6596', '601', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6597', '602', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6598', '602', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6599', '603', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6600', '603', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6601', '604', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6602', '604', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6603', '605', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6604', '605', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6605', '606', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6606', '606', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6607', '607', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6608', '607', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6609', '608', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6610', '608', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6611', '609', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6612', '609', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6613', '610', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6614', '610', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6615', '611', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6616', '611', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6617', '612', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6618', '612', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6619', '613', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6620', '613', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6621', '614', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6622', '614', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6623', '615', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6624', '615', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6625', '616', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6626', '616', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6627', '617', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6628', '617', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6629', '618', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6630', '618', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6631', '619', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6632', '619', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6633', '620', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6634', '620', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6635', '621', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6636', '621', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6637', '622', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6638', '622', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6639', '623', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6640', '623', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6641', '624', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6642', '624', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6643', '625', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6644', '625', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6645', '626', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6646', '626', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6647', '627', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6648', '627', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6649', '628', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6650', '628', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6651', '629', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6652', '629', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6653', '630', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6654', '630', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6655', '631', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6656', '631', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6657', '632', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6658', '632', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6659', '633', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6660', '633', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6661', '634', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6662', '634', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6663', '635', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6664', '635', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6665', '636', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6666', '636', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6667', '637', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6668', '637', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6669', '638', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6670', '638', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6671', '639', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6672', '639', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6673', '640', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6674', '640', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6675', '641', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6676', '641', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6677', '642', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6678', '642', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6679', '643', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6680', '643', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6681', '644', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6682', '644', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6683', '645', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6684', '645', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6685', '646', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6686', '646', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6687', '647', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6688', '647', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6689', '648', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6690', '648', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6691', '649', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6692', '649', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6693', '650', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6694', '650', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6695', '651', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6696', '651', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6697', '652', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6698', '652', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6699', '653', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6700', '653', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6701', '654', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6702', '654', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6703', '655', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6704', '655', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6705', '656', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6706', '656', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6707', '657', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6708', '657', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6709', '658', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6710', '658', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6711', '659', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6712', '659', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6713', '660', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6714', '660', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6715', '661', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6716', '661', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6717', '662', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6718', '662', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6719', '663', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6720', '663', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6721', '664', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6722', '664', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6723', '665', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6724', '665', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6725', '666', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6726', '666', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6727', '667', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6728', '667', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6729', '668', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6730', '668', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6731', '669', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6732', '669', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6733', '670', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6734', '670', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6735', '671', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6736', '671', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6737', '672', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6738', '672', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6739', '673', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6740', '673', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6741', '674', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6742', '674', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6743', '675', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6744', '675', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6745', '676', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6746', '676', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6747', '677', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6748', '677', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6749', '678', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6750', '678', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6751', '679', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6752', '679', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6753', '680', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6754', '680', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6755', '681', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6756', '681', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6757', '682', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6758', '682', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6759', '683', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6760', '683', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6761', '684', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6762', '684', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6763', '685', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6764', '685', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6765', '1', 'FP', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6766', '686', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6767', '686', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6768', '687', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6769', '687', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6770', '688', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6771', '688', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6772', '689', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6773', '689', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6774', '690', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6775', '690', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6776', '691', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6777', '691', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6778', '692', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6779', '692', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6780', '693', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6781', '693', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6782', '694', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6783', '694', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6784', '695', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6785', '695', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6786', '696', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6787', '696', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6788', '697', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6789', '697', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6790', '698', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6791', '698', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6792', '699', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6793', '699', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6794', '700', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6795', '700', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6796', '701', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6797', '701', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6798', '702', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6799', '702', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6800', '703', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6801', '703', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6802', '704', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6803', '704', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6804', '705', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6805', '705', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6806', '706', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6807', '706', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6808', '707', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6809', '707', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6810', '708', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6811', '708', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6812', '709', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6813', '709', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6814', '710', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6815', '710', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6816', '711', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6817', '711', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6818', '712', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6819', '712', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6820', '713', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6821', '713', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6822', '714', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6823', '714', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6824', '715', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6825', '715', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6826', '716', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6827', '716', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6828', '717', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6829', '717', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6830', '718', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6831', '718', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6832', '719', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6833', '719', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6834', '720', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6835', '720', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6836', '721', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6837', '721', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6838', '722', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6839', '722', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6840', '723', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6841', '723', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6842', '724', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6843', '724', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6844', '725', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6845', '725', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6846', '726', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6847', '726', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6848', '2', 'FP', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6849', '727', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6850', '727', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6851', '728', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6852', '728', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6853', '729', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6854', '729', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6855', '730', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6856', '730', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6857', '731', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6858', '731', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6859', '732', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6860', '732', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6861', '733', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6862', '733', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6863', '734', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6864', '734', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6865', '735', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6866', '735', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6867', '736', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6868', '736', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6869', '737', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6870', '737', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6871', '738', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6872', '738', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6873', '739', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6874', '739', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6875', '740', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6876', '740', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6877', '741', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6878', '741', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6879', '742', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6880', '742', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6881', '743', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6882', '743', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6883', '744', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6884', '744', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6885', '745', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6886', '745', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6887', '746', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6888', '746', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6889', '747', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6890', '747', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6891', '748', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6892', '748', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6893', '749', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6894', '749', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6895', '750', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6896', '750', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6897', '751', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6898', '751', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6899', '752', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6900', '752', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6901', '753', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6902', '753', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6903', '754', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6904', '754', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6905', '755', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6906', '755', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6907', '756', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6908', '756', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6909', '757', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6910', '757', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6911', '758', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6912', '758', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6913', '759', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6914', '759', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6915', '760', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6916', '760', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6917', '761', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6918', '761', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6919', '762', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6920', '762', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6921', '763', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6922', '763', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6923', '764', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6924', '764', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6925', '765', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6926', '765', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6927', '766', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6928', '766', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6929', '767', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6930', '767', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6931', '768', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6932', '768', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6933', '769', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6934', '769', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6935', '770', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6936', '770', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6937', '771', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6938', '771', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6939', '772', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6940', '772', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6941', '773', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6942', '773', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6943', '774', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6944', '774', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6945', '775', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6946', '775', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6947', '776', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6948', '776', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6949', '777', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6950', '777', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6951', '778', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6952', '778', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6953', '779', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6954', '779', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6955', '780', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6956', '780', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6957', '781', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6958', '781', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6959', '782', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6960', '782', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6961', '783', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6962', '783', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6963', '784', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6964', '784', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6965', '785', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6966', '785', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6967', '786', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6968', '786', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6969', '787', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6970', '787', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6971', '788', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6972', '788', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6973', '789', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6974', '789', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6975', '790', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6976', '790', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6977', '791', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6978', '791', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6979', '792', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6980', '792', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6981', '793', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6982', '793', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6983', '794', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6984', '794', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6985', '795', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6986', '795', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6987', '796', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6988', '796', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6989', '797', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6990', '797', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6991', '798', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6992', '798', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6993', '799', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6994', '799', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6995', '800', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6996', '800', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6997', '801', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6998', '801', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('6999', '802', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7000', '802', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7001', '803', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7002', '803', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7003', '804', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7004', '804', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7005', '805', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7006', '805', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7007', '806', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7008', '806', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7009', '807', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7010', '807', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7011', '808', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7012', '808', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7013', '809', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7014', '809', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7015', '810', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7016', '810', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7017', '811', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7018', '811', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7019', '812', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7020', '812', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7021', '813', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7022', '813', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7023', '814', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7024', '814', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7025', '815', 'RC', '2022');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('7026', '815', 'FR', '2022');
INSERT INTO `tec_numbering` (`id`, `number`